/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.credential;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.AttributesManager;
import org.picketlink.idm.api.SecureRandomProvider;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.credential.AbstractHashingWithSaltEncoder;

public class DatabaseReadingSaltEncoder
extends AbstractHashingWithSaltEncoder {
    public static final String PASSWORD_SALT_USER_ATTRIBUTE = "passwordSalt";
    private static final String OPTION_CREDENTIAL_ENCODER_SECURE_RANDOM_ALGORITHM = "credentialEncoder.secureRandomAlgorithm";
    private static final String OPTION_DEFAULT_SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    public static final String OPTION_SECURE_RANDOM_PROVIDER_REGISTRY_NAME = "credentialEncoder.secureRandom.providerRegistryName";
    public static final String DEFAULT_SECURE_RANDOM_PROVIDER_REGISTRY_NAME = "secureRandomProvider";
    private SecureRandomProvider registeredSecureRandomProvider;
    private String secureRandomAlgorithm;

    @Override
    protected void afterInitialize() {
        super.afterInitialize();
        String registeredName = this.getEncoderProperty(OPTION_SECURE_RANDOM_PROVIDER_REGISTRY_NAME);
        if (registeredName == null) {
            registeredName = DEFAULT_SECURE_RANDOM_PROVIDER_REGISTRY_NAME;
        }
        try {
            if (this.getConfigurationRegistry() != null) {
                this.registeredSecureRandomProvider = (SecureRandomProvider)this.getConfigurationRegistry().getObject(registeredName);
                this.log.info("Registered SecureRandomProvider will be used for random generating of password salts");
                return;
            }
        }
        catch (IdentityException ie) {
            this.log.fine("SecureRandomProvider not registered. We will always create new SecureRandom");
        }
        this.secureRandomAlgorithm = this.getEncoderProperty(OPTION_CREDENTIAL_ENCODER_SECURE_RANDOM_ALGORITHM);
        if (this.secureRandomAlgorithm == null) {
            this.secureRandomAlgorithm = OPTION_DEFAULT_SECURE_RANDOM_ALGORITHM;
        }
        this.log.info("Algorithm " + this.secureRandomAlgorithm + " will be used for random generating of password salts");
    }

    @Override
    protected String getSalt(String username) {
        try {
            AttributesManager am = this.getIdentitySession().getAttributesManager();
            Attribute salt = am.getAttribute(username, PASSWORD_SALT_USER_ATTRIBUTE);
            if (salt == null) {
                SecureRandom pseudoRng = this.getSecureRandomInstance();
                String saltStr = String.valueOf(pseudoRng.nextLong());
                am.addAttribute(username, PASSWORD_SALT_USER_ATTRIBUTE, (Object)saltStr);
                this.log.fine("Salt has been randomly generated for user " + username);
                return saltStr;
            }
            return (String)salt.getValue();
        }
        catch (Exception ie) {
            throw new RuntimeException(ie);
        }
    }

    protected SecureRandom getSecureRandomInstance() throws NoSuchAlgorithmException {
        if (this.registeredSecureRandomProvider != null) {
            return this.registeredSecureRandomProvider.getSecureRandom();
        }
        return SecureRandom.getInstance(this.secureRandomAlgorithm);
    }
}

