/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.ott;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.ott.OneTimeTokenAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.StringUtils;

public class OneTimeTokenAuthenticationConverter
implements AuthenticationConverter {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public Authentication convert(HttpServletRequest request) {
        String token = request.getParameter("token");
        if (!StringUtils.hasText((String)token)) {
            this.logger.debug((Object)"No token found in request");
            return null;
        }
        return OneTimeTokenAuthenticationToken.unauthenticated((String)token);
    }
}

