/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168.api;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.lang.reflect.UndeclaredThrowableException;
import javax.portlet.PortletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.portlet.impl.jsr168.api.PortletRequestImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PortletResponseImpl
implements PortletResponse {
    private static final ThreadLocal<DocumentBuilder> builder = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
    };
    protected final PortletInvocation invocation;
    protected final PortletRequestImpl preq;
    private Document doc;
    private ResponseProperties properties;
    private HttpServletResponseWrapper realResp;

    protected PortletResponseImpl(PortletInvocation invocation, PortletRequestImpl preq) {
        this.invocation = invocation;
        this.preq = preq;
        this.realResp = new HttpServletResponseWrapper(invocation.getDispatchedResponse());
    }

    public abstract PortletInvocationResponse getResponse();

    public String encodeURL(String url) {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null");
        }
        return this.invocation.getContext().encodeResourceURL(url);
    }

    public void addProperty(String key, String value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this.getProperties().getTransportHeaders().addValue(key, (Object)value);
    }

    public void setProperty(String key, String value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this.getProperties().getTransportHeaders().setValue(key, (Object)value);
    }

    public void addProperty(Cookie cookie) {
        this.getProperties().getCookies().add(cookie);
    }

    public void addProperty(String key, Element element) {
        this.getProperties().getMarkupHeaders().addValue(key, (Object)element);
    }

    public Element createElement(String tagName) throws DOMException {
        if (this.doc == null) {
            this.doc = builder.get().newDocument();
        }
        return this.doc.createElement(tagName);
    }

    public String getNamespace() {
        return this.invocation.getWindowContext().getNamespace();
    }

    public final HttpServletResponseWrapper getRealResponse() {
        return this.realResp;
    }

    protected final ResponseProperties getProperties() {
        return this.getProperties(true);
    }

    protected final ResponseProperties getProperties(boolean create) {
        if (this.properties == null && create) {
            this.properties = new ResponseProperties();
        }
        return this.properties;
    }
}

