/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.DistanceUnit;
import co.elastic.clients.elasticsearch._types.GeoDistanceType;
import co.elastic.clients.elasticsearch._types.GeoLocation;
import co.elastic.clients.elasticsearch._types.NestedSortValue;
import co.elastic.clients.elasticsearch._types.SortMode;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOptionsVariant;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoDistanceSort
implements SortOptionsVariant,
JsonpSerializable {
    private final String field;
    private final List<GeoLocation> location;
    @Nullable
    private final SortMode mode;
    @Nullable
    private final GeoDistanceType distanceType;
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final SortOrder order;
    @Nullable
    private final DistanceUnit unit;
    @Nullable
    private final NestedSortValue nested;
    public static final JsonpDeserializer<GeoDistanceSort> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoDistanceSort::setupGeoDistanceSortDeserializer);

    private GeoDistanceSort(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.location = ApiTypeHelper.unmodifiableRequired(builder.location, (Object)this, "location");
        this.mode = builder.mode;
        this.distanceType = builder.distanceType;
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.order = builder.order;
        this.unit = builder.unit;
        this.nested = builder.nested;
    }

    public static GeoDistanceSort of(Function<Builder, ObjectBuilder<GeoDistanceSort>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SortOptions.Kind _sortOptionsKind() {
        return SortOptions.Kind.GeoDistance;
    }

    public final String field() {
        return this.field;
    }

    public final List<GeoLocation> location() {
        return this.location;
    }

    @Nullable
    public final SortMode mode() {
        return this.mode;
    }

    @Nullable
    public final GeoDistanceType distanceType() {
        return this.distanceType;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public final SortOrder order() {
        return this.order;
    }

    @Nullable
    public final DistanceUnit unit() {
        return this.unit;
    }

    @Nullable
    public final NestedSortValue nested() {
        return this.nested;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        generator.writeStartArray();
        for (GeoLocation item0 : this.location) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
        if (this.distanceType != null) {
            generator.writeKey("distance_type");
            this.distanceType.serialize(generator, mapper);
        }
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (this.unit != null) {
            generator.writeKey("unit");
            this.unit.serialize(generator, mapper);
        }
        if (this.nested != null) {
            generator.writeKey("nested");
            this.nested.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGeoDistanceSortDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mode, SortMode._DESERIALIZER, "mode");
        op.add(Builder::distanceType, GeoDistanceType._DESERIALIZER, "distance_type");
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.add(Builder::order, SortOrder._DESERIALIZER, "order");
        op.add(Builder::unit, DistanceUnit._DESERIALIZER, "unit");
        op.add(Builder::nested, NestedSortValue._DESERIALIZER, "nested");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.location(JsonpDeserializer.arrayDeserializer(GeoLocation._DESERIALIZER).deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GeoDistanceSort> {
        private String field;
        private List<GeoLocation> location;
        @Nullable
        private SortMode mode;
        @Nullable
        private GeoDistanceType distanceType;
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private SortOrder order;
        @Nullable
        private DistanceUnit unit;
        @Nullable
        private NestedSortValue nested;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder location(List<GeoLocation> list) {
            this.location = Builder._listAddAll(this.location, list);
            return this;
        }

        public final Builder location(GeoLocation value, GeoLocation ... values) {
            this.location = Builder._listAdd(this.location, value, values);
            return this;
        }

        public final Builder location(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.location(fn.apply(new GeoLocation.Builder()).build(), new GeoLocation[0]);
        }

        public final Builder mode(@Nullable SortMode value) {
            this.mode = value;
            return this;
        }

        public final Builder distanceType(@Nullable GeoDistanceType value) {
            this.distanceType = value;
            return this;
        }

        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        public final Builder order(@Nullable SortOrder value) {
            this.order = value;
            return this;
        }

        public final Builder unit(@Nullable DistanceUnit value) {
            this.unit = value;
            return this;
        }

        public final Builder nested(@Nullable NestedSortValue value) {
            this.nested = value;
            return this;
        }

        public final Builder nested(Function<NestedSortValue.Builder, ObjectBuilder<NestedSortValue>> fn) {
            return this.nested(fn.apply(new NestedSortValue.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoDistanceSort build() {
            this._checkSingleUse();
            return new GeoDistanceSort(this);
        }
    }
}

