/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.url;

import java.util.Collections;
import java.util.Set;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.url.PortalURL;
import org.exoplatform.web.url.ResourceType;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.webui.core.UIComponent;
import org.gatein.common.util.Tools;

public class ComponentURL
extends PortalURL<UIComponent, ComponentURL> {
    public static final String PORTAL_COMPONENT_ID = "portal:componentId";
    public static final String PORTAL_COMPONENT_ACTION = "portal:action";
    public static final ResourceType<UIComponent, ComponentURL> TYPE = new ResourceType<UIComponent, ComponentURL>(){};
    public static final QualifiedName PATH = QualifiedName.create((String)"gtn", (String)"path");
    private static final Set<QualifiedName> NAMES = Collections.unmodifiableSet(Tools.toSet((Object[])new QualifiedName[]{PATH}));
    private UIComponent resource;
    private String action;
    private String path;

    public ComponentURL(URLContext context) throws NullPointerException {
        super(context);
    }

    public UIComponent getResource() {
        return this.resource;
    }

    public ComponentURL setResource(UIComponent resource) {
        this.resource = resource;
        if (resource != null) {
            this.setQueryParameterValue(PORTAL_COMPONENT_ID, resource.getId());
        }
        return this;
    }

    public void reset() {
        super.reset();
        if (this.resource != null) {
            this.setQueryParameterValue(PORTAL_COMPONENT_ID, this.resource.getId());
        }
        this.setQueryParameterValue(PORTAL_COMPONENT_ACTION, this.action);
    }

    public Set<QualifiedName> getParameterNames() {
        return NAMES;
    }

    public String getParameterValue(QualifiedName parameterName) {
        if (PATH.equals((Object)parameterName)) {
            return this.path;
        }
        return null;
    }

    public void setAction(String action) {
        this.action = action;
        this.setQueryParameterValue(PORTAL_COMPONENT_ACTION, action);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

