/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.cms.storage;

import io.meeds.social.cms.model.CMSSetting;
import io.meeds.social.cms.storage.model.CMSSettingMetadataObject;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;

public class CMSStorage {
    public static final String METADATA_TYPE = "CMSSetting";
    private MetadataService metadataService;

    public CMSStorage(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public CMSSetting getSetting(String type, String name) {
        List metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject(METADATA_TYPE, (MetadataObject)new CMSSettingMetadataObject(type, name));
        return metadataItems.stream().map(item -> new CMSSetting(type, name, item.getMetadata().getName(), item.getSpaceId())).findFirst().orElse(null);
    }

    public void saveSetting(String type, String name, String pageReference, long spaceId, long userCreatorId) throws ObjectAlreadyExistsException {
        CMSSettingMetadataObject cmsSettingObject = new CMSSettingMetadataObject(type, name, spaceId);
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE, pageReference, spaceId);
        this.metadataService.createMetadataItem((MetadataObject)cmsSettingObject, metadataKey, userCreatorId);
    }
}

