/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.service.ProgramService;
import io.meeds.social.translation.plugin.TranslationPlugin;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProgramTranslationPlugin
extends TranslationPlugin {
    public static final String PROGRAM_OBJECT_TYPE = "program";
    public static final String PROGRAM_DESCRIPTION_FIELD_NAME = "description";
    public static final String PROGRAM_TITLE_FIELD_NAME = "title";
    @Autowired
    private ProgramService programService;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private UserACL userACL;
    @Autowired
    private PortalContainer container;

    @PostConstruct
    public void init() {
        ((TranslationService)this.container.getComponentInstanceOfType(TranslationService.class)).addPlugin((TranslationPlugin)this);
    }

    public String getObjectType() {
        return PROGRAM_OBJECT_TYPE;
    }

    public boolean hasAccessPermission(String programId, String username) throws ObjectNotFoundException {
        return this.userACL.hasAccessPermission(PROGRAM_OBJECT_TYPE, programId, username);
    }

    public boolean hasEditPermission(String programId, String username) throws ObjectNotFoundException {
        return this.userACL.hasEditPermission(PROGRAM_OBJECT_TYPE, programId, username);
    }

    public long getAudienceId(String programId) throws ObjectNotFoundException {
        long spaceId = this.getSpaceId(programId);
        if (spaceId == 0L) {
            return 0L;
        }
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            throw new ObjectNotFoundException(String.format("Space with id %s wasn't found", spaceId));
        }
        Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        return Long.parseLong(spaceIdentity.getId());
    }

    public long getSpaceId(String programId) throws ObjectNotFoundException {
        ProgramDTO program = this.programService.getProgramById(Long.parseLong(programId));
        if (program == null) {
            throw new ObjectNotFoundException(String.format("Program with id %s wasn't found", programId));
        }
        return program.getSpaceId();
    }
}

