/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.storage;

import io.meeds.layout.model.LayoutModel;
import io.meeds.layout.model.NavigationCreateModel;
import io.meeds.layout.model.SectionTemplate;
import io.meeds.layout.service.ContainerLayoutService;
import io.meeds.layout.service.NavigationLayoutService;
import io.meeds.layout.service.PageLayoutService;
import io.meeds.layout.util.EntityMapper;
import io.meeds.social.util.JsonUtils;
import java.util.ArrayList;
import lombok.Generated;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SectionTemplateLayoutStorage {
    @Generated
    private final Object $lock = new Object[0];
    public static final String GLOBAL_SITE_NAME = "global";
    public static final SiteKey GLOBAL_SITE_KEY = SiteKey.portal((String)"global");
    private static final String[] EVERYONE_PERMISSIONS = new String[]{"Everyone"};
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private NavigationService navigationService;
    @Autowired
    private PageLayoutService pageLayoutService;
    @Autowired
    private ContainerLayoutService containerLayoutService;
    @Autowired
    private NavigationLayoutService navigationLayoutService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeData generateSectionTemplateNodeId(SectionTemplate sectionTemplate, String username) throws IllegalAccessException, ObjectNotFoundException {
        Object object = this.$lock;
        synchronized (object) {
            PageKey clonedPageKey = this.clonePage(sectionTemplate, username);
            String clonedNodeName = this.getSectionNodeName(sectionTemplate.getId(), username);
            NodeContext parentNode = this.navigationService.loadNode(GLOBAL_SITE_KEY);
            NodeContext<NodeContext<Object>> clonedNode = this.navigationLayoutService.findNode((NodeContext<NodeContext<Object>>)parentNode, clonedNodeName);
            if (clonedNode == null) {
                return this.navigationLayoutService.createNode(new NavigationCreateModel(Long.parseLong(parentNode.getId()), null, clonedNodeName, clonedNodeName, false, false, true, null, null, clonedPageKey.format(), null, false, null, null), username);
            }
            NodeState state = clonedNode.getState().builder().pageRef(clonedPageKey).build();
            long nodeId = Long.parseLong(clonedNode.getId());
            this.navigationService.updateNode(Long.valueOf(nodeId), state);
            return this.navigationService.getNodeById(Long.valueOf(nodeId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateSectionTemplateContent(SectionTemplate sectionTemplate, String username) {
        Object object = this.$lock;
        synchronized (object) {
            String clonedNodeName = this.getSectionNodeName(sectionTemplate.getId(), username);
            NodeContext parentNode = this.navigationService.loadNode(GLOBAL_SITE_KEY);
            NodeContext<NodeContext<Object>> nodeData = this.navigationLayoutService.findNode((NodeContext<NodeContext<Object>>)parentNode, clonedNodeName);
            PageKey pageKey = nodeData.getState().getPageRef();
            return this.generateSectionTemplateContent(pageKey);
        }
    }

    public String generateSectionTemplateContent(SectionTemplate sectionTemplate, Container section, String username) {
        section = this.containerLayoutService.cloneContainer(section);
        String sectionTemplateContent = JsonUtils.toJsonString((Object)new LayoutModel((ModelObject)section));
        PageKey pageKey = this.createSectionTemplatePage(sectionTemplate.getId(), sectionTemplateContent, username);
        return this.generateSectionTemplateContent(pageKey);
    }

    private PageKey clonePage(SectionTemplate sectionTemplate, String username) {
        long sectionTemplateId = sectionTemplate.getId();
        String sectionTemplateContent = sectionTemplate.getContent();
        return this.createSectionTemplatePage(sectionTemplateId, sectionTemplateContent, username);
    }

    private PageKey createSectionTemplatePage(long sectionTemplateId, String sectionTemplateContent, String username) {
        Container parentContainer = new Container();
        parentContainer.setTemplate("system:/groovy/portal/webui/container/UIPageLayout.gtmpl");
        parentContainer.setChildren(new ArrayList());
        LayoutModel layoutModel = (LayoutModel)JsonUtils.fromJsonString((String)sectionTemplateContent, LayoutModel.class);
        layoutModel.resetStorage();
        parentContainer.getChildren().add(EntityMapper.toModelObject(layoutModel));
        Page sectionDraftPage = new Page();
        sectionDraftPage.setAccessPermissions(EVERYONE_PERMISSIONS);
        sectionDraftPage.setOwnerType(PortalConfig.PORTAL_TYPE);
        sectionDraftPage.setOwnerId(GLOBAL_SITE_NAME);
        sectionDraftPage.setName(this.getSectionNodeName(sectionTemplateId, username));
        sectionDraftPage.setTitle("Section Template Draft " + username);
        sectionDraftPage.setChildren(new ArrayList());
        sectionDraftPage.getChildren().add(parentContainer);
        PageKey clonedPageKey = sectionDraftPage.getPageKey();
        this.layoutService.save(new PageContext(clonedPageKey, Utils.toPageState((Page)sectionDraftPage)), sectionDraftPage);
        this.pageLayoutService.impersonatePage(clonedPageKey);
        return clonedPageKey;
    }

    private String generateSectionTemplateContent(PageKey pageKey) {
        Page page = this.layoutService.getPage(pageKey);
        Container section = (Container)((Container)page.getChildren().get(0)).getChildren().get(0);
        this.containerLayoutService.exportPortletPreferences((ModelObject)section);
        LayoutModel sectionLayoutModel = new LayoutModel((ModelObject)section);
        sectionLayoutModel.resetStorage();
        return JsonUtils.toJsonString((Object)sectionLayoutModel);
    }

    private String getSectionNodeName(long sectionTemplateId, String username) {
        return "section_draft_" + sectionTemplateId + "_" + username;
    }
}

