/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profile;

import org.exoplatform.social.common.lifecycle.AbstractLifeCycle;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListener;

public class ProfileLifeCycle
extends AbstractLifeCycle<ProfileListener, ProfileLifeCycleEvent> {
    @Override
    protected void dispatchEvent(ProfileListener listener, ProfileLifeCycleEvent event) {
        switch (event.getType()) {
            case ABOUT_ME: {
                listener.aboutMeUpdated(event);
                break;
            }
            case AVATAR_UPDATED: {
                listener.avatarUpdated(event);
                break;
            }
            case BASIC_UPDATED: {
                listener.basicInfoUpdated(event);
                break;
            }
            case CONTACT_UPDATED: {
                listener.contactSectionUpdated(event);
                break;
            }
            case EXPERIENCE_UPDATED: {
                listener.experienceSectionUpdated(event);
                break;
            }
            case HEADER_UPDATED: {
                listener.headerSectionUpdated(event);
                break;
            }
            case CREATED: {
                listener.createProfile(event);
                break;
            }
            case BANNER_UPDATED: {
                listener.bannerUpdated(event);
                break;
            }
            case TECHNICAL_UPDATED: {
                listener.technicalUpdated(event);
                break;
            }
        }
    }

    public void aboutMeUpdated(String username, Profile profile, String modifierUsername) {
        this.broadcast(ProfileLifeCycleEvent.Type.ABOUT_ME, profile, username, modifierUsername);
    }

    public void avatarUpdated(String username, Profile profile, String modifierUsername) {
        this.broadcast(ProfileLifeCycleEvent.Type.AVATAR_UPDATED, profile, username, modifierUsername);
    }

    public void bannerUpdated(String username, Profile profile, String modifierUsername) {
        this.broadcast(ProfileLifeCycleEvent.Type.BANNER_UPDATED, profile, username, modifierUsername);
    }

    public void technicalUpdated(String username, Profile profile, String modifierUsername) {
        this.broadcast(ProfileLifeCycleEvent.Type.TECHNICAL_UPDATED, profile, username, modifierUsername);
    }

    public void basicUpdated(String username, Profile profile, String modifierUsername) {
        this.broadcast(ProfileLifeCycleEvent.Type.BASIC_UPDATED, profile, username, modifierUsername);
    }

    public void contactUpdated(String username, Profile profile, String modifierUsername) {
        this.broadcast(ProfileLifeCycleEvent.Type.CONTACT_UPDATED, profile, username, modifierUsername);
    }

    public void experienceUpdated(String username, Profile profile, String modifierUsername) {
        this.broadcast(ProfileLifeCycleEvent.Type.EXPERIENCE_UPDATED, profile, username, modifierUsername);
    }

    public void headerUpdated(String username, Profile profile, String modifierUsername) {
        this.broadcast(ProfileLifeCycleEvent.Type.HEADER_UPDATED, profile, username, modifierUsername);
    }

    public void createProfile(Profile profile) {
        this.broadcast(ProfileLifeCycleEvent.Type.CREATED, profile, profile.getIdentity().getRemoteId(), null);
    }

    private void broadcast(ProfileLifeCycleEvent.Type type, Profile profile, String username, String modifierUsername) {
        this.broadcast(new ProfileLifeCycleEvent(type, username, profile, modifierUsername));
    }
}

