/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pc.aspects;

import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.pc.portlet.PortletInvokerInterceptor;

public class PortletLifecyclePhaseInterceptor
extends PortletInvokerInterceptor {
    private static final ThreadLocal<PortletInvocation> INVOCATION_THREAD_LOCAL = new ThreadLocal();

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        try {
            INVOCATION_THREAD_LOCAL.set(invocation);
            PortletInvocationResponse portletInvocationResponse = super.invoke(invocation);
            return portletInvocationResponse;
        }
        finally {
            INVOCATION_THREAD_LOCAL.remove();
        }
    }

    public static String currentPhase() {
        PortletInvocation invocation = PortletLifecyclePhaseInterceptor.getCurrentInvocation();
        if (invocation == null) {
            return null;
        }
        if (invocation instanceof ActionInvocation) {
            return "ACTION_PHASE";
        }
        if (invocation instanceof EventInvocation) {
            return "EVENT_PHASE";
        }
        if (invocation instanceof RenderInvocation) {
            return "RENDER_PHASE";
        }
        if (invocation instanceof ResourceInvocation) {
            return "RESOURCE_PHASE";
        }
        return null;
    }

    public static String currentWindowId() {
        PortletInvocation invocation = PortletLifecyclePhaseInterceptor.getCurrentInvocation();
        if (invocation == null) {
            return null;
        }
        WindowContext wc = invocation.getWindowContext();
        if (wc == null) {
            return null;
        }
        return wc.getId();
    }

    private static PortletInvocation getCurrentInvocation() {
        return INVOCATION_THREAD_LOCAL.get();
    }
}

