/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet;

import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private static final Pattern MAJOR_MINOR_PATTERN = Pattern.compile("^(\\d)+\\.(\\d)+");
    public static final String VALUE;
    public static final int MAJOR;
    public static final int MINOR;

    public static void main(String[] args) {
        System.out.println("version=" + VALUE);
        System.out.println("major=" + MAJOR);
        System.out.println("minor=" + MINOR);
    }

    static {
        String value = "0.0.0-GA";
        int major = 0;
        int minor = 0;
        try {
            Properties props = new Properties();
            InputStream in = Version.class.getResourceAsStream("/META-INF/maven/org.gatein.pc/pc-portlet/pom.properties");
            if (in != null) {
                Matcher matcher;
                props.load(in);
                String version = props.getProperty("version");
                if (version != null && (version = version.trim()).length() > 0 && (matcher = MAJOR_MINOR_PATTERN.matcher(value = version.trim())).find()) {
                    major = Integer.parseInt(matcher.group(1));
                    minor = Integer.parseInt(matcher.group(2));
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(Version.class.getName()).log(Level.WARNING, "Could not load version from maven", e);
        }
        VALUE = value;
        MAJOR = major;
        MINOR = minor;
    }
}

