/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168.api;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import org.gatein.pc.api.cache.CacheControl;
import org.gatein.pc.api.cache.CacheScope;
import org.gatein.pc.api.info.CacheInfo;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.api.invocation.response.RevalidateMarkupResponse;
import org.gatein.pc.portlet.impl.info.ContainerPortletInfo;
import org.gatein.pc.portlet.impl.jsr168.Buffer;
import org.gatein.pc.portlet.impl.jsr168.ByteBuffer;
import org.gatein.pc.portlet.impl.jsr168.CharBuffer;
import org.gatein.pc.portlet.impl.jsr168.api.CacheControlImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletRequestImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletResponseImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletURLImpl;
import org.gatein.pc.portlet.impl.jsr168.api.ResourceURLImpl;

public abstract class MimeResponseImpl
extends PortletResponseImpl
implements MimeResponse {
    protected int bufferSize = 0;
    protected CacheControlImpl cacheControl;
    private Buffer buffer = null;
    private String contentType;

    public MimeResponseImpl(PortletInvocation invocation, PortletRequestImpl preq) {
        super(invocation, preq);
    }

    protected abstract ContentResponse createResponse(ResponseProperties var1, Map<String, Object> var2, String var3, byte[] var4, CacheControl var5);

    protected abstract ContentResponse createResponse(ResponseProperties var1, Map<String, Object> var2, String var3, String var4, CacheControl var5);

    protected abstract ContentResponse createResponse(ResponseProperties var1, Map<String, Object> var2, String var3, CacheControl var4);

    @Override
    public PortletInvocationResponse getResponse() {
        CacheControl cc;
        if (this.cacheControl != null) {
            cc = new CacheControl(this.cacheControl.getExpirationTime(), this.cacheControl.isPublicScope() ? CacheScope.PUBLIC : CacheScope.PRIVATE, this.cacheControl.getETag());
        } else {
            ContainerPortletInfo info = this.preq.container.getInfo();
            CacheInfo cacheInfo = info.getCache();
            cc = new CacheControl(cacheInfo.getExpirationSecs(), CacheScope.PRIVATE, null);
        }
        if (this.cacheControl != null && this.cacheControl.useCachedContent()) {
            return new RevalidateMarkupResponse(cc);
        }
        ResponseProperties props = this.getProperties(false);
        Map<String, Object> attrs = this.preq.attributes.getAttributeMap();
        if (this.buffer instanceof CharBuffer) {
            return this.createResponse(props, attrs, this.contentType, ((CharBuffer)this.buffer).getChars(), cc);
        }
        if (this.buffer instanceof ByteBuffer) {
            return this.createResponse(props, attrs, this.contentType, ((ByteBuffer)this.buffer).getBytes(), cc);
        }
        return this.createResponse(props, attrs, this.contentType, cc);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        if (this.buffer == null) {
            this.contentType = contentType;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PrintWriter getWriter() throws IOException {
        CharBuffer charBuffer;
        if (this.buffer != null) {
            if (!(this.buffer instanceof CharBuffer)) throw new IllegalStateException("The method getPortletOutputStream() was already called");
            charBuffer = (CharBuffer)this.buffer;
            return charBuffer.getWriter();
        } else {
            charBuffer = new CharBuffer();
            this.buffer = charBuffer;
        }
        return charBuffer.getWriter();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OutputStream getPortletOutputStream() throws IOException {
        ByteBuffer byteBuffer;
        if (this.buffer != null) {
            if (!(this.buffer instanceof ByteBuffer)) throw new IllegalStateException("The method getWriter() was already called");
            byteBuffer = (ByteBuffer)this.buffer;
            return byteBuffer.getOutputStream();
        } else {
            byteBuffer = new ByteBuffer();
            this.buffer = byteBuffer;
        }
        return byteBuffer.getOutputStream();
    }

    public PortletURL createRenderURL() {
        return PortletURLImpl.createRenderURL(this.invocation, this.preq);
    }

    public PortletURL createActionURL() {
        return PortletURLImpl.createActionURL(this.invocation, this.preq);
    }

    public Locale getLocale() {
        return this.invocation.getUserContext().getLocale();
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        if (this.buffer != null) {
            this.buffer.commit();
        }
    }

    public void resetBuffer() {
        if (this.buffer != null) {
            this.buffer.reset();
        }
    }

    public void reset() {
        this.resetBuffer();
        this.getProperties().clear();
    }

    public boolean isCommitted() {
        return this.buffer != null && this.buffer.isCommited();
    }

    public ResourceURL createResourceURL() {
        return ResourceURLImpl.createResourceURL(this.invocation, this.preq);
    }

    private void setCache(String key, String value) {
        if ("portlet.expiration-cache".equals(key)) {
            if (value != null) {
                try {
                    int expirationSecs = Integer.parseInt(value);
                    this.getCacheControl().setExpirationTime(expirationSecs);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if ("portlet.ETag".equals(key)) {
            if (value != null) {
                this.getCacheControl().setETag(value);
            }
        } else if ("portlet.use-cached-content".equals(key) && value != null) {
            this.getCacheControl().setUseCachedContent(true);
        }
    }

    @Override
    public void addProperty(String key, String value) throws IllegalArgumentException {
        if ("portlet.expiration-cache".equals(key) || "portlet.ETag".equals(key) || "portlet.use-cached-content".equals(key)) {
            this.setCache(key, value);
        } else {
            super.addProperty(key, value);
        }
    }

    @Override
    public void setProperty(String key, String value) throws IllegalArgumentException {
        if ("portlet.expiration-cache".equals(key) || "portlet.ETag".equals(key) || "portlet.use-cached-content".equals(key)) {
            this.setCache(key, value);
        } else {
            super.setProperty(key, value);
        }
    }

    public javax.portlet.CacheControl getCacheControl() {
        if (this.cacheControl == null) {
            ContainerPortletInfo info = this.preq.container.getInfo();
            CacheInfo cacheInfo = info.getCache();
            this.cacheControl = new CacheControlImpl(cacheInfo.getExpirationSecs(), CacheScope.PRIVATE);
        }
        return this.cacheControl;
    }
}

