/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.complementaryfilter;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.jpa.search.ComplementaryFilterSearchConnector;

@Path(value="v1/social/complementaryfilter")
@Tag(name="v1/social/complementaryfilter", description="Managing complementary filter")
public class ComplementaryFilterRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ComplementaryFilterRest.class);
    private final ComplementaryFilterSearchConnector complementaryFilterSearchConnector;

    public ComplementaryFilterRest(ComplementaryFilterSearchConnector complementaryFilterSearchConnector) {
        this.complementaryFilterSearchConnector = complementaryFilterSearchConnector;
    }

    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="suggestions/{indexAlias}")
    @Operation(summary="Gets complementary filter suggestions", description="Gets complementary filter suggestions based on attributes", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getComplementaryFilterSuggestions(@RequestBody(description="filter object ids") List<String> objectIds, @Parameter(description="filter attributes") @QueryParam(value="attributes") List<String> attributes, @Parameter(description="min count of occurrence") @QueryParam(value="minDocCount") @DefaultValue(value="2") int minDocCount, @Parameter(description="target search index alias") @PathParam(value="indexAlias") String indexAlias) {
        if (objectIds.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Objects Ids list is mandatory").build();
        }
        if (attributes.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"attributes list is mandatory").build();
        }
        if (indexAlias == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"target index alias is mandatory").build();
        }
        try {
            List result = this.complementaryFilterSearchConnector.search(attributes, objectIds, minDocCount, indexAlias);
            return Response.ok((Object)result).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting complementary filter suggestions", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

