/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.web.HttpSessionStateKey;

public class SetCurrentIdentityFilter
extends AbstractFilter {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.security.core.SetCurrentIdentityFilter");
    private ConversationRegistry conversationRegistry;
    private IdentityRegistry identityRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ExoContainer container = this.getContainer();
        try {
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
            ConversationState state = this.getCurrentState(container, httpRequest);
            ConversationState.setCurrent(state);
            chain.doFilter(request, response);
        }
        finally {
            try {
                ConversationState.setCurrent(null);
            }
            catch (Exception e) {
                LOG.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
            try {
                ExoContainerContext.setCurrentContainer(null);
            }
            catch (Exception e) {
                LOG.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
        }
    }

    private ConversationState getCurrentState(ExoContainer container, HttpServletRequest httpRequest) {
        ConversationState state = null;
        String userId = httpRequest.getRemoteUser();
        if (userId != null) {
            HttpSession httpSession = httpRequest.getSession();
            HttpSessionStateKey stateKey = new HttpSessionStateKey(httpSession);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Looking for Conversation State " + httpSession.getId()));
            }
            if ((state = this.getConversationRegistry(container).getState(stateKey)) != null && !userId.equals(state.getIdentity().getUserId())) {
                state = null;
                this.getConversationRegistry(container).unregister(stateKey, false);
                LOG.debug((Object)("The current conversation state with the session ID " + httpSession.getId() + " does not belong to the user " + userId + ". The conversation state registry will be updated."));
            }
            if (state == null) {
                Identity identity;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Conversation State not found, try create new one.");
                }
                if ((identity = this.getIdentityRegistry(container).getIdentity(userId)) != null) {
                    state = new ConversationState(identity);
                    state.setAttribute("subject", identity.getSubject());
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Not found identity for " + userId + " try to restore it. "));
                    }
                    Authenticator authenticator = (Authenticator)container.getComponentInstanceOfType(Authenticator.class);
                    try {
                        identity = authenticator.createIdentity(userId);
                        this.getIdentityRegistry(container).register(identity);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Unable restore identity. " + e.getMessage()), (Throwable)e);
                    }
                    if (identity != null) {
                        state = new ConversationState(identity);
                    }
                }
                if (state != null) {
                    this.getConversationRegistry(container).register(stateKey, state);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Register Conversation state " + httpSession.getId()));
                    }
                }
            }
        } else {
            state = new ConversationState(new Identity(IdentityConstants.ANONIM));
        }
        return state;
    }

    public ConversationRegistry getConversationRegistry(ExoContainer container) {
        if (this.conversationRegistry == null) {
            this.conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
        }
        return this.conversationRegistry;
    }

    public IdentityRegistry getIdentityRegistry(ExoContainer container) {
        if (this.identityRegistry == null) {
            this.identityRegistry = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
        }
        return this.identityRegistry;
    }
}

