/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.common.service.utils.LogWatch;

public class TraceElement {
    private AtomicLong elapsedTime = new AtomicLong(0L);
    private final String traceName;
    private final LogWatch logWatch;
    private TraceElement parent;
    private List<TraceElement> children;

    private TraceElement(String traceName) {
        this.logWatch = new LogWatch(traceName);
        this.traceName = traceName;
    }

    public List<TraceElement> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<TraceElement>();
        }
        return this.children;
    }

    public static TraceElement getInstance(String traceName) {
        return new TraceElement(traceName);
    }

    public TraceElement addChild(String traceName) {
        TraceElement child = TraceElement.getInstance(traceName);
        child.setParrent(this);
        this.getChildren().add(child);
        return child;
    }

    public void start() {
        this.logWatch.start();
    }

    public void end() {
        this.elapsedTime.set(this.logWatch.elapsedTime());
    }

    public long getElapsedTime() {
        return this.elapsedTime.get();
    }

    public TraceElement getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public void setParrent(TraceElement parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.traceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TraceElement)) {
            return false;
        }
        TraceElement element = (TraceElement)o;
        return this.traceName == element.traceName;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.traceName != null ? this.traceName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("%s - %s ", this.traceName, this.logWatch.toString(this.getElapsedTime(), TimeUnit.MILLISECONDS));
    }

    public String toReport() {
        StringBuffer out = new StringBuffer();
        if (this.getChildren().size() > 0) {
            out.append("{");
            int len = this.getChildren().size();
            int index = 0;
            for (TraceElement e : this.getChildren()) {
                if (++index > 1) {
                    out.append("{space}");
                }
                out.append(e.toString());
                if (index < len) {
                    out.append("\n");
                }
                this.elapsedTime.addAndGet(e.getElapsedTime());
            }
            out.append("}");
        }
        String head = String.format("%s - %s ", this.traceName, this.logWatch.toString(this.getElapsedTime(), TimeUnit.MILLISECONDS));
        String tail = StringUtils.replace((String)out.toString(), (String)"{space}", (String)StringUtils.repeat((String)" ", (int)(head.length() + 1)));
        return head + tail;
    }
}

