/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich;

import co.elastic.clients.elasticsearch.enrich.EnrichPolicy;
import co.elastic.clients.elasticsearch.enrich.EnrichPolicyType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.Pair;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class EnrichSummary
implements JsonpSerializable {
    private final Pair<EnrichPolicyType, EnrichPolicy> config;
    public static final JsonpDeserializer<EnrichSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EnrichSummary::setupEnrichSummaryDeserializer);

    private EnrichSummary(Builder builder) {
        this.config = ApiTypeHelper.requireNonNull(builder.config, this, "config");
    }

    public static EnrichSummary of(Function<Builder, ObjectBuilder<EnrichSummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Pair<EnrichPolicyType, EnrichPolicy> config() {
        return this.config;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("config");
        generator.writeStartObject();
        generator.writeKey(this.config.key().jsonValue());
        this.config.value().serialize(generator, mapper);
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupEnrichSummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::config, Pair.deserializer(k -> (EnrichPolicyType)EnrichPolicyType._DESERIALIZER.parse((String)k), EnrichPolicy._DESERIALIZER), "config");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<EnrichSummary> {
        private Pair<EnrichPolicyType, EnrichPolicy> config;

        public final Builder config(Pair<EnrichPolicyType, EnrichPolicy> value) {
            this.config = value;
            return this;
        }

        public Builder config(EnrichPolicyType key, EnrichPolicy value) {
            this.config = new Pair<EnrichPolicyType, EnrichPolicy>(key, value);
            return this;
        }

        public Builder config(EnrichPolicyType key, Function<EnrichPolicy.Builder, ObjectBuilder<EnrichPolicy>> fn) {
            return this.config(key, fn.apply(new EnrichPolicy.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EnrichSummary build() {
            this._checkSingleUse();
            return new EnrichSummary(this);
        }
    }
}

