/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.ApiClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.transport.Transport;
import org.reactivestreams.Publisher;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchExceptionTranslator;
import org.springframework.data.elasticsearch.client.elc.RequestConverter;
import org.springframework.data.elasticsearch.client.elc.ResponseConverter;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class ReactiveChildTemplate<T extends Transport, CLIENT extends ApiClient<T, CLIENT>> {
    protected final CLIENT client;
    protected final ElasticsearchConverter elasticsearchConverter;
    protected final RequestConverter requestConverter;
    protected final ResponseConverter responseConverter;
    protected final ElasticsearchExceptionTranslator exceptionTranslator;

    public ReactiveChildTemplate(CLIENT client, ElasticsearchConverter elasticsearchConverter) {
        this.client = client;
        this.elasticsearchConverter = elasticsearchConverter;
        JsonpMapper jsonpMapper = client._transport().jsonpMapper();
        this.requestConverter = new RequestConverter(elasticsearchConverter, jsonpMapper);
        this.responseConverter = new ResponseConverter(jsonpMapper);
        this.exceptionTranslator = new ElasticsearchExceptionTranslator(jsonpMapper);
    }

    public <RESULT> Publisher<RESULT> execute(ClientCallback<CLIENT, Publisher<RESULT>> callback) {
        Assert.notNull(callback, (String)"callback must not be null");
        return Flux.defer(() -> callback.doWithClient(this.client)).onErrorMap(this.exceptionTranslator::translateException);
    }

    @FunctionalInterface
    public static interface ClientCallback<CLIENT, RESULT extends Publisher<?>> {
        public RESULT doWithClient(CLIENT var1);
    }
}

