/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.api.exceptions;

import org.gatein.management.api.ManagedUser;
import org.gatein.management.api.exceptions.OperationException;

public class NotAuthorizedException
extends OperationException {
    public NotAuthorizedException(String operationName, String message) {
        super(operationName, message);
    }

    public NotAuthorizedException(String operationName, String message, Throwable cause) {
        super(operationName, message, cause);
    }

    public NotAuthorizedException(ManagedUser user, String operationName) {
        super(operationName, NotAuthorizedException.createMessage(user, operationName));
    }

    public NotAuthorizedException(ManagedUser user, String operationName, Throwable cause) {
        super(operationName, NotAuthorizedException.createMessage(user, operationName), cause);
    }

    private static String createMessage(ManagedUser user, String operationName) {
        if (user == null) {
            return "Authentication required for operation " + operationName;
        }
        return user.getUserName() + " is not authorized to execute operation " + operationName;
    }
}

