/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyAggregation;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyAggregationVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MissingAggregation
extends BucketAggregationBase
implements AggregationVariant,
ApiKeyAggregationVariant,
JsonpSerializable {
    @Nullable
    private final String field;
    @Nullable
    private final FieldValue missing;
    public static final JsonpDeserializer<MissingAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MissingAggregation::setupMissingAggregationDeserializer);

    private MissingAggregation(Builder builder) {
        this.field = builder.field;
        this.missing = builder.missing;
    }

    public static MissingAggregation of(Function<Builder, ObjectBuilder<MissingAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Missing;
    }

    @Override
    public ApiKeyAggregation.Kind _apiKeyAggregationKind() {
        return ApiKeyAggregation.Kind.Missing;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final FieldValue missing() {
        return this.missing;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            this.missing.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupMissingAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::missing, FieldValue._DESERIALIZER, "missing");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MissingAggregation> {
        @Nullable
        private String field;
        @Nullable
        private FieldValue missing;

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder missing(@Nullable FieldValue value) {
            this.missing = value;
            return this;
        }

        public final Builder missing(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.missing(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder missing(String value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(long value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(double value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(boolean value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MissingAggregation build() {
            this._checkSingleUse();
            return new MissingAggregation(this);
        }
    }
}

