/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.mapping.DiscriminatorValueDetails;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class DiscriminatorConverter<O, R>
implements BasicValueConverter<O, R> {
    private final String discriminatorName;
    private final JavaType<O> domainJavaType;
    private final JavaType<R> relationalJavaType;

    public DiscriminatorConverter(String discriminatorName, JavaType<O> domainJavaType, JavaType<R> relationalJavaType) {
        this.discriminatorName = discriminatorName;
        this.domainJavaType = domainJavaType;
        this.relationalJavaType = relationalJavaType;
    }

    public String getDiscriminatorName() {
        return this.discriminatorName;
    }

    @Override
    public JavaType<O> getDomainJavaType() {
        return this.domainJavaType;
    }

    @Override
    public JavaType<R> getRelationalJavaType() {
        return this.relationalJavaType;
    }

    public DiscriminatorValueDetails getDetailsForRelationalForm(R relationalForm) {
        return this.getDetailsForDiscriminatorValue(relationalForm);
    }

    @Override
    public O toDomainValue(R relationalForm) {
        assert (relationalForm == null || this.relationalJavaType.isInstance(relationalForm));
        DiscriminatorValueDetails matchingValueDetails = this.getDetailsForRelationalForm(relationalForm);
        if (matchingValueDetails == null) {
            throw new IllegalStateException("Could not resolve discriminator value");
        }
        EntityMappingType indicatedEntity = matchingValueDetails.getIndicatedEntity();
        return (O)(indicatedEntity.getRepresentationStrategy().getMode() == RepresentationMode.POJO && indicatedEntity.getEntityName().equals(indicatedEntity.getJavaType().getJavaTypeClass().getName()) ? indicatedEntity.getJavaType().getJavaTypeClass() : indicatedEntity.getEntityName());
    }

    @Override
    public R toRelationalValue(O domainForm) {
        assert (domainForm == null || domainForm instanceof String || domainForm instanceof Class);
        if (domainForm == null) {
            return null;
        }
        String entityName = domainForm instanceof Class ? ((Class)domainForm).getName() : (String)domainForm;
        DiscriminatorValueDetails discriminatorValueDetails = this.getDetailsForEntityName(entityName);
        return (R)discriminatorValueDetails.getValue();
    }

    public abstract DiscriminatorValueDetails getDetailsForDiscriminatorValue(Object var1);

    public abstract DiscriminatorValueDetails getDetailsForEntityName(String var1);

    public String toString() {
        return "DiscriminatorConverter(" + this.discriminatorName + ")";
    }

    public abstract void forEachValueDetail(Consumer<DiscriminatorValueDetails> var1);

    public abstract <X> X fromValueDetails(Function<DiscriminatorValueDetails, X> var1);
}

