/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.notification.job;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import lombok.Generated;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.notification.service.SpaceWebNotificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
public class SpaceWebNotificationCleanupJob {
    @Generated
    private final Object $lock = new Object[0];
    private static final NumberFormat INTEGER_FORMAT_INSTANCE = NumberFormat.getIntegerInstance();
    private static final DateFormat DATE_TIME_FORMAT_INSTANCE = DateFormat.getDateTimeInstance();
    private static final Log LOG = ExoLogger.getLogger(SpaceWebNotificationCleanupJob.class);
    private static final int DAY_IN_MS = 86400000;
    @Autowired
    private SpaceWebNotificationService spaceWebNotificationService;
    @Value(value="${social.SpaceWebNotificationCleanupJob.keepAlive.days:30}")
    private int keepAliveDays;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="${social.SpaceWebNotificationCleanupJob.expression:0 5 23 ? * *}")
    public void run() {
        Object object = this.$lock;
        synchronized (object) {
            long start = System.currentTimeMillis();
            long untilDate = start - (long)(this.keepAliveDays * 86400000);
            String untilFormatedDate = DATE_TIME_FORMAT_INSTANCE.format(new Date(untilDate));
            LOG.info("Delete unread activities created before {}", new Object[]{untilFormatedDate});
            int deletedUnreadNotifications = this.spaceWebNotificationService.markAllAsReadUntil(untilDate);
            if (deletedUnreadNotifications > 0) {
                LOG.info("{} unread activities has been marked as read which was created before {}. Operation suceeded within {}ms", new Object[]{INTEGER_FORMAT_INSTANCE.format(deletedUnreadNotifications), untilFormatedDate, INTEGER_FORMAT_INSTANCE.format(System.currentTimeMillis() - start)});
            }
        }
    }
}

