/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.security.plugin;

import io.meeds.web.security.plugin.OtpPlugin;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.web.security.security.SecureRandomService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EmailOtpPlugin
implements OtpPlugin {
    private static final Pattern I18N_LABEL_PATTERN = Pattern.compile("\\$\\{([a-zA-Z0-9\\.]+)\\}");
    private static final String OTP_CACHE_NAME = "otp.email";
    private static final String LANG_PARAM = "$LANG";
    private static final String USER_FULL_NAME_PARAM = "$USER_FULL_NAME";
    private static final String SITE_NAME_PARAM = "$SITE_NAME";
    private static final String COMPANY_LINK_PARAM = "$COMPANY_LINK";
    private static final String CODE_EXPIRATION_LABEL_PARAM = "$CODE_EXPIRATION_LABEL";
    private static final String PRIMARY_COLOR_PARAM = "$PRIMARY_COLOR";
    @Autowired
    private CacheService cacheService;
    @Autowired
    private SecureRandomService secureRandomService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private ResourceBundleService resourceBundleService;
    @Autowired
    private BrandingService brandingService;
    @Autowired
    private MailService mailService;
    @Value(value="${meeds.apiKey.otp.email.ttl:5}")
    private long otpTtl;
    @Value(value="${meeds.apiKey.otp.email.length:5}")
    private long otpLength;
    @Value(value="${meeds.apiKey.otp.email.templatePath:assets/otp-email.html}")
    private String emailBodyPath;
    private SecureRandom secureRandom;
    private String emailBodyTemplate;
    private ExoCache<String, String> otpCache;

    public String getName() {
        return "email";
    }

    public boolean canUse(String userName) {
        return true;
    }

    public boolean validateOtp(String userName, String otpCode) {
        return StringUtils.equals((CharSequence)otpCode, (CharSequence)((CharSequence)this.getOtpCache().get((Serializable)((Object)userName))));
    }

    public void generateOtpCode(String userName) {
        String email = this.getUserMail(userName);
        String userFullName = this.getUserFullName(userName);
        String lang = this.getUserLang(userName);
        String otpCode = this.generateOtpCode();
        this.getOtpCache().put((Serializable)((Object)userName), (Object)otpCode);
        this.sendEmail(email, userFullName, String.valueOf(otpCode), lang);
    }

    private void sendEmail(String to, String userFullName, String otpCode, String lang) throws Exception {
        String emailSubject = this.getEmailSubject(lang);
        String emailBody = this.getEmailBody(userFullName, lang, otpCode);
        String from = this.getSenderFullEmail();
        MimeMessage mimeMessage = new MimeMessage(this.mailService.getMailSession());
        mimeMessage.setFrom(from);
        mimeMessage.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        mimeMessage.setSubject(StringEscapeUtils.unescapeHtml4((String)emailSubject), "UTF-8");
        mimeMessage.setSentDate(new Date());
        mimeMessage.setContent((Object)emailBody, "text/html; charset=utf-8");
        this.mailService.sendMessage(mimeMessage);
    }

    private String getSenderFullEmail() {
        String senderEmail;
        try {
            senderEmail = MailUtils.getSenderEmail();
        }
        catch (Exception e) {
            senderEmail = System.getProperty("gatein.email.smtp.from");
        }
        String senderName = this.brandingService.getCompanyName();
        return StringUtils.isBlank((CharSequence)senderName) ? senderEmail : senderName + "<" + senderEmail + ">";
    }

    private String generateOtpCode() {
        return String.valueOf(this.getSecureRandom().nextLong((long)Math.pow(10.0, (double)this.otpLength - 1.0), (long)Math.pow(10.0, this.otpLength)));
    }

    private String getUserMail(String userName) throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName(userName);
        if (user == null) {
            throw new IllegalArgumentException();
        }
        return user.getEmail();
    }

    private String getUserFullName(String userName) throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName(userName);
        if (user == null) {
            throw new IllegalArgumentException();
        }
        return user.getDisplayName();
    }

    private String getUserLang(String userName) throws Exception {
        UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(userName);
        if (userProfile != null && userProfile.getAttribute("user.language") != null) {
            return userProfile.getAttribute("user.language");
        }
        return ResourceBundleService.DEFAULT_CROWDIN_LANGUAGE;
    }

    private String getEmailSubject(String lang) {
        return this.resourceBundleService.getSharedString("otp.email.subject", LocaleUtils.toLocale((String)lang));
    }

    private String getEmailBody(String userFullName, String lang, String otpCode) {
        String content = this.getEmailBody();
        Matcher matcher = I18N_LABEL_PATTERN.matcher(content);
        while (matcher.find()) {
            String i18nKey = matcher.group(1);
            String label = this.resourceBundleService.getSharedString(i18nKey, LocaleUtils.toLocale((String)lang));
            content = content.replace(matcher.group(), label);
        }
        content = content.replace("####", otpCode);
        content = content.replace(LANG_PARAM, lang);
        content = content.replace(USER_FULL_NAME_PARAM, userFullName);
        content = content.replace(SITE_NAME_PARAM, this.brandingService.getCompanyName());
        content = content.replace(COMPANY_LINK_PARAM, LinkProviderUtils.getBaseUrl());
        content = content.replace(CODE_EXPIRATION_LABEL_PARAM, this.getCodeExpirationLabel(lang));
        content = content.replace(PRIMARY_COLOR_PARAM, (CharSequence)this.brandingService.getThemeStyle().get("primaryColor"));
        return content;
    }

    private String getCodeExpirationLabel(String lang) {
        return this.resourceBundleService.getSharedString("otp.email.label.codeExpirationMessage", LocaleUtils.toLocale((String)lang)).replace("{0}", String.valueOf(this.otpTtl));
    }

    private String getEmailBody() {
        if (this.emailBodyTemplate == null) {
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.emailBodyPath);){
                this.emailBodyTemplate = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            }
        }
        return this.emailBodyTemplate;
    }

    private SecureRandom getSecureRandom() {
        if (this.secureRandom == null) {
            this.secureRandom = this.secureRandomService.getSecureRandom();
        }
        return this.secureRandom;
    }

    private ExoCache<String, String> getOtpCache() {
        if (this.otpCache == null) {
            this.otpCache = this.cacheService.getCacheInstance(OTP_CACHE_NAME);
            this.otpCache.setLiveTime(this.otpTtl * 60L);
        }
        return this.otpCache;
    }

    @Generated
    public long getOtpTtl() {
        return this.otpTtl;
    }

    @Generated
    public void setOtpTtl(long otpTtl) {
        this.otpTtl = otpTtl;
    }

    @Generated
    public long getOtpLength() {
        return this.otpLength;
    }

    @Generated
    public void setOtpLength(long otpLength) {
        this.otpLength = otpLength;
    }

    @Generated
    public String getEmailBodyPath() {
        return this.emailBodyPath;
    }

    @Generated
    public void setEmailBodyPath(String emailBodyPath) {
        this.emailBodyPath = emailBodyPath;
    }

    @Generated
    public void setEmailBodyTemplate(String emailBodyTemplate) {
        this.emailBodyTemplate = emailBodyTemplate;
    }

    @Generated
    public void setOtpCache(ExoCache<String, String> otpCache) {
        this.otpCache = otpCache;
    }
}

