/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.link.storage.cache;

import io.meeds.content.link.model.Link;
import io.meeds.content.link.model.LinkSetting;
import io.meeds.content.link.storage.LinkStorage;
import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CachedLinkStorage
extends LinkStorage {
    public static final String CACHE_NAME = "social.linkSettings";
    @Autowired
    private CacheService cacheService;
    private FutureExoCache<Serializable, LinkSetting, Object> futureCache;

    @PostConstruct
    public void init() {
        ExoCache cache = this.cacheService.getCacheInstance(CACHE_NAME);
        Loader<Serializable, LinkSetting, Object> loader = new Loader<Serializable, LinkSetting, Object>(){

            public LinkSetting retrieve(Object context, Serializable key) throws Exception {
                Serializable serializable = key;
                Objects.requireNonNull(serializable);
                Serializable serializable2 = serializable;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Long.class}, (Object)serializable2, n)) {
                    case 0 -> {
                        String name = (String)((Object)serializable2);
                        yield CachedLinkStorage.super.getLinkSetting(name);
                    }
                    case 1 -> {
                        Long id = (Long)serializable2;
                        yield CachedLinkStorage.super.getLinkSetting(id);
                    }
                    default -> null;
                };
            }
        };
        this.futureCache = new FutureExoCache((Loader)loader, cache);
    }

    @Override
    public LinkSetting getLinkSetting(String name) {
        return this.clone((LinkSetting)this.futureCache.get(null, (Object)name));
    }

    @Override
    public LinkSetting getLinkSetting(Long id) {
        return this.clone((LinkSetting)this.futureCache.get(null, (Object)id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkSetting initLinkSetting(String name, String pageId, long spaceId) {
        try {
            LinkSetting linkSetting = super.initLinkSetting(name, pageId, spaceId);
            return linkSetting;
        }
        finally {
            this.clearLinkSetting(name);
        }
    }

    @Override
    public LinkSetting saveLinkSetting(LinkSetting linkSetting) {
        try {
            LinkSetting linkSetting2 = super.saveLinkSetting(linkSetting);
            return linkSetting2;
        }
        finally {
            this.futureCache.remove((Serializable)((Object)linkSetting.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Link createLink(String linkSettingName, Link link) {
        try {
            Link link2 = super.createLink(linkSettingName, link);
            return link2;
        }
        finally {
            this.clearLinkSetting(linkSettingName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Link updateLink(String linkSettingName, Link link) {
        try {
            Link link2 = super.updateLink(linkSettingName, link);
            return link2;
        }
        finally {
            this.clearLinkSetting(linkSettingName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteLink(String linkSettingName, long id) {
        try {
            super.deleteLink(linkSettingName, id);
        }
        finally {
            this.clearLinkSetting(linkSettingName);
        }
    }

    private void clearLinkSetting(String name) {
        LinkSetting linkSetting = (LinkSetting)this.futureCache.get((Serializable)((Object)name));
        if (linkSetting != null) {
            this.futureCache.remove((Serializable)((Object)name));
            this.futureCache.remove((Serializable)Long.valueOf(linkSetting.getId()));
        }
    }

    private LinkSetting clone(LinkSetting linkSetting) {
        return linkSetting == null ? null : linkSetting.clone();
    }
}

