/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.news.utils;

import io.meeds.content.news.model.ArticleTarget;
import io.meeds.content.news.model.News;
import io.meeds.content.news.rest.model.NewsSearchResultEntity;
import io.meeds.content.news.search.NewsESSearchResult;
import io.meeds.social.html.model.HtmlTransformerContext;
import io.meeds.social.html.utils.HtmlUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.portal.application.localization.LocalizationFilter;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;

public class EntityBuilder {
    public static NewsSearchResultEntity toSearchResultEntity(NewsESSearchResult searchResult, News news, Identity identity) {
        if (news == null) {
            return null;
        }
        NewsSearchResultEntity result = new NewsSearchResultEntity();
        result.setId(news.getId());
        result.setTitle(news.getTitle());
        result.setSummary(news.getProperties() != null ? news.getProperties().getSummary() : null);
        result.setLang(news.getLang());
        result.setSpaceId(news.getSpaceId());
        result.setNewsUrl(news.getUrl());
        result.setLastUpdatedTime(news.getUpdateDate() != null ? news.getUpdateDate().getTime() : 0L);
        result.setFavorite(news.isFavorite());
        result.setActivityId(news.getActivityId());
        result.setUpdaterUserName(news.getUpdater() != null ? news.getUpdater() : news.getAuthor());
        result.setSpaceAvatar(news.getSpaceAvatarUrl());
        result.setSpaceDisplayName(news.getSpaceDisplayName());
        result.setBody(HtmlUtils.transform((String)news.getBody(), (HtmlTransformerContext)new HtmlTransformerContext(identity, LocalizationFilter.getCurrentLocale())));
        result.setExcerpts(!CollectionUtils.isNotEmpty(searchResult.getExcerpts()) ? null : searchResult.getExcerpts().stream().map(text -> HtmlUtils.transform((String)text, (HtmlTransformerContext)new HtmlTransformerContext(identity, LocalizationFilter.getCurrentLocale(), true))).toList());
        return result;
    }

    public static ArticleTarget toArticleTarget(MetadataItem metadataItem) {
        if (metadataItem == null) {
            return null;
        }
        Metadata metadata = metadataItem.getMetadata();
        Map properties = metadataItem.getProperties();
        String publishedDate = properties != null ? properties.getOrDefault("publishedDate", "0") : "0";
        return new ArticleTarget(metadata.getName(), Long.parseLong(publishedDate));
    }

    public static List<ArticleTarget> toArticleTargets(List<MetadataItem> metadataItems) {
        if (CollectionUtils.isEmpty(metadataItems)) {
            return null;
        }
        return metadataItems.stream().map(EntityBuilder::toArticleTarget).toList();
    }
}

