/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.jaas;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class DigestCallbackHandler
implements CallbackHandler {
    private String login;
    private char[] password;
    private final String authMethod = "DIGEST";
    private final Map<String, String> passwordContext;

    public DigestCallbackHandler(String login, char[] password, Map<String, String> passwordContext) {
        this.login = login;
        this.password = password;
        this.passwordContext = passwordContext;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                ((NameCallback)callbacks[i]).setName(this.login);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                ((PasswordCallback)callbacks[i]).setPassword(this.password);
                continue;
            }
            if (callbacks[i] instanceof TextInputCallback) {
                if ("authMethod".equals(((TextInputCallback)callbacks[i]).getPrompt())) {
                    ((TextInputCallback)callbacks[i]).setText("DIGEST");
                    continue;
                }
                if ("cnonce".equals(((TextInputCallback)callbacks[i]).getPrompt())) {
                    ((TextInputCallback)callbacks[i]).setText(this.passwordContext.get("cnonce"));
                    continue;
                }
                if ("md5a2".equals(((TextInputCallback)callbacks[i]).getPrompt())) {
                    ((TextInputCallback)callbacks[i]).setText(this.passwordContext.get("md5a2"));
                    continue;
                }
                if ("nc".equals(((TextInputCallback)callbacks[i]).getPrompt())) {
                    ((TextInputCallback)callbacks[i]).setText(this.passwordContext.get("nc"));
                    continue;
                }
                if ("nonce".equals(((TextInputCallback)callbacks[i]).getPrompt())) {
                    ((TextInputCallback)callbacks[i]).setText(this.passwordContext.get("nonce"));
                    continue;
                }
                if ("qop".equals(((TextInputCallback)callbacks[i]).getPrompt())) {
                    ((TextInputCallback)callbacks[i]).setText(this.passwordContext.get("qop"));
                    continue;
                }
                if (!"realmName".equals(((TextInputCallback)callbacks[i]).getPrompt())) continue;
                ((TextInputCallback)callbacks[i]).setText(this.passwordContext.get("realmName"));
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Callback class not supported");
        }
    }
}

