/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch.indices.stats.ShardFileSizeInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SegmentsStats
implements JsonpSerializable {
    private final int count;
    @Nullable
    private final String docValuesMemory;
    private final long docValuesMemoryInBytes;
    private final Map<String, ShardFileSizeInfo> fileSizes;
    @Nullable
    private final String fixedBitSet;
    private final long fixedBitSetMemoryInBytes;
    @Nullable
    private final String indexWriterMemory;
    private final long indexWriterMemoryInBytes;
    private final long maxUnsafeAutoIdTimestamp;
    @Nullable
    private final String memory;
    private final long memoryInBytes;
    @Nullable
    private final String normsMemory;
    private final long normsMemoryInBytes;
    @Nullable
    private final String pointsMemory;
    private final long pointsMemoryInBytes;
    private final long storedFieldsMemoryInBytes;
    @Nullable
    private final String storedFieldsMemory;
    private final long termsMemoryInBytes;
    @Nullable
    private final String termsMemory;
    @Nullable
    private final String termVectorsMemory;
    private final long termVectorsMemoryInBytes;
    @Nullable
    private final String versionMapMemory;
    private final long versionMapMemoryInBytes;
    public static final JsonpDeserializer<SegmentsStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SegmentsStats::setupSegmentsStatsDeserializer);

    private SegmentsStats(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.docValuesMemory = builder.docValuesMemory;
        this.docValuesMemoryInBytes = ApiTypeHelper.requireNonNull(builder.docValuesMemoryInBytes, (Object)this, "docValuesMemoryInBytes", 0L);
        this.fileSizes = ApiTypeHelper.unmodifiableRequired(builder.fileSizes, (Object)this, "fileSizes");
        this.fixedBitSet = builder.fixedBitSet;
        this.fixedBitSetMemoryInBytes = ApiTypeHelper.requireNonNull(builder.fixedBitSetMemoryInBytes, (Object)this, "fixedBitSetMemoryInBytes", 0L);
        this.indexWriterMemory = builder.indexWriterMemory;
        this.indexWriterMemoryInBytes = ApiTypeHelper.requireNonNull(builder.indexWriterMemoryInBytes, (Object)this, "indexWriterMemoryInBytes", 0L);
        this.maxUnsafeAutoIdTimestamp = ApiTypeHelper.requireNonNull(builder.maxUnsafeAutoIdTimestamp, (Object)this, "maxUnsafeAutoIdTimestamp", 0L);
        this.memory = builder.memory;
        this.memoryInBytes = ApiTypeHelper.requireNonNull(builder.memoryInBytes, (Object)this, "memoryInBytes", 0L);
        this.normsMemory = builder.normsMemory;
        this.normsMemoryInBytes = ApiTypeHelper.requireNonNull(builder.normsMemoryInBytes, (Object)this, "normsMemoryInBytes", 0L);
        this.pointsMemory = builder.pointsMemory;
        this.pointsMemoryInBytes = ApiTypeHelper.requireNonNull(builder.pointsMemoryInBytes, (Object)this, "pointsMemoryInBytes", 0L);
        this.storedFieldsMemoryInBytes = ApiTypeHelper.requireNonNull(builder.storedFieldsMemoryInBytes, (Object)this, "storedFieldsMemoryInBytes", 0L);
        this.storedFieldsMemory = builder.storedFieldsMemory;
        this.termsMemoryInBytes = ApiTypeHelper.requireNonNull(builder.termsMemoryInBytes, (Object)this, "termsMemoryInBytes", 0L);
        this.termsMemory = builder.termsMemory;
        this.termVectorsMemory = builder.termVectorsMemory;
        this.termVectorsMemoryInBytes = ApiTypeHelper.requireNonNull(builder.termVectorsMemoryInBytes, (Object)this, "termVectorsMemoryInBytes", 0L);
        this.versionMapMemory = builder.versionMapMemory;
        this.versionMapMemoryInBytes = ApiTypeHelper.requireNonNull(builder.versionMapMemoryInBytes, (Object)this, "versionMapMemoryInBytes", 0L);
    }

    public static SegmentsStats of(Function<Builder, ObjectBuilder<SegmentsStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int count() {
        return this.count;
    }

    @Nullable
    public final String docValuesMemory() {
        return this.docValuesMemory;
    }

    public final long docValuesMemoryInBytes() {
        return this.docValuesMemoryInBytes;
    }

    public final Map<String, ShardFileSizeInfo> fileSizes() {
        return this.fileSizes;
    }

    @Nullable
    public final String fixedBitSet() {
        return this.fixedBitSet;
    }

    public final long fixedBitSetMemoryInBytes() {
        return this.fixedBitSetMemoryInBytes;
    }

    @Nullable
    public final String indexWriterMemory() {
        return this.indexWriterMemory;
    }

    public final long indexWriterMemoryInBytes() {
        return this.indexWriterMemoryInBytes;
    }

    public final long maxUnsafeAutoIdTimestamp() {
        return this.maxUnsafeAutoIdTimestamp;
    }

    @Nullable
    public final String memory() {
        return this.memory;
    }

    public final long memoryInBytes() {
        return this.memoryInBytes;
    }

    @Nullable
    public final String normsMemory() {
        return this.normsMemory;
    }

    public final long normsMemoryInBytes() {
        return this.normsMemoryInBytes;
    }

    @Nullable
    public final String pointsMemory() {
        return this.pointsMemory;
    }

    public final long pointsMemoryInBytes() {
        return this.pointsMemoryInBytes;
    }

    public final long storedFieldsMemoryInBytes() {
        return this.storedFieldsMemoryInBytes;
    }

    @Nullable
    public final String storedFieldsMemory() {
        return this.storedFieldsMemory;
    }

    public final long termsMemoryInBytes() {
        return this.termsMemoryInBytes;
    }

    @Nullable
    public final String termsMemory() {
        return this.termsMemory;
    }

    @Nullable
    public final String termVectorsMemory() {
        return this.termVectorsMemory;
    }

    public final long termVectorsMemoryInBytes() {
        return this.termVectorsMemoryInBytes;
    }

    @Nullable
    public final String versionMapMemory() {
        return this.versionMapMemory;
    }

    public final long versionMapMemoryInBytes() {
        return this.versionMapMemoryInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (this.docValuesMemory != null) {
            generator.writeKey("doc_values_memory");
            generator.write(this.docValuesMemory);
        }
        generator.writeKey("doc_values_memory_in_bytes");
        generator.write(this.docValuesMemoryInBytes);
        if (ApiTypeHelper.isDefined(this.fileSizes)) {
            generator.writeKey("file_sizes");
            generator.writeStartObject();
            for (Map.Entry<String, ShardFileSizeInfo> item0 : this.fileSizes.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.fixedBitSet != null) {
            generator.writeKey("fixed_bit_set");
            generator.write(this.fixedBitSet);
        }
        generator.writeKey("fixed_bit_set_memory_in_bytes");
        generator.write(this.fixedBitSetMemoryInBytes);
        if (this.indexWriterMemory != null) {
            generator.writeKey("index_writer_memory");
            generator.write(this.indexWriterMemory);
        }
        generator.writeKey("index_writer_memory_in_bytes");
        generator.write(this.indexWriterMemoryInBytes);
        generator.writeKey("max_unsafe_auto_id_timestamp");
        generator.write(this.maxUnsafeAutoIdTimestamp);
        if (this.memory != null) {
            generator.writeKey("memory");
            generator.write(this.memory);
        }
        generator.writeKey("memory_in_bytes");
        generator.write(this.memoryInBytes);
        if (this.normsMemory != null) {
            generator.writeKey("norms_memory");
            generator.write(this.normsMemory);
        }
        generator.writeKey("norms_memory_in_bytes");
        generator.write(this.normsMemoryInBytes);
        if (this.pointsMemory != null) {
            generator.writeKey("points_memory");
            generator.write(this.pointsMemory);
        }
        generator.writeKey("points_memory_in_bytes");
        generator.write(this.pointsMemoryInBytes);
        generator.writeKey("stored_fields_memory_in_bytes");
        generator.write(this.storedFieldsMemoryInBytes);
        if (this.storedFieldsMemory != null) {
            generator.writeKey("stored_fields_memory");
            generator.write(this.storedFieldsMemory);
        }
        generator.writeKey("terms_memory_in_bytes");
        generator.write(this.termsMemoryInBytes);
        if (this.termsMemory != null) {
            generator.writeKey("terms_memory");
            generator.write(this.termsMemory);
        }
        if (this.termVectorsMemory != null) {
            generator.writeKey("term_vectors_memory");
            generator.write(this.termVectorsMemory);
        }
        generator.writeKey("term_vectors_memory_in_bytes");
        generator.write(this.termVectorsMemoryInBytes);
        if (this.versionMapMemory != null) {
            generator.writeKey("version_map_memory");
            generator.write(this.versionMapMemory);
        }
        generator.writeKey("version_map_memory_in_bytes");
        generator.write(this.versionMapMemoryInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSegmentsStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::docValuesMemory, JsonpDeserializer.stringDeserializer(), "doc_values_memory");
        op.add(Builder::docValuesMemoryInBytes, JsonpDeserializer.longDeserializer(), "doc_values_memory_in_bytes");
        op.add(Builder::fileSizes, JsonpDeserializer.stringMapDeserializer(ShardFileSizeInfo._DESERIALIZER), "file_sizes");
        op.add(Builder::fixedBitSet, JsonpDeserializer.stringDeserializer(), "fixed_bit_set");
        op.add(Builder::fixedBitSetMemoryInBytes, JsonpDeserializer.longDeserializer(), "fixed_bit_set_memory_in_bytes");
        op.add(Builder::indexWriterMemory, JsonpDeserializer.stringDeserializer(), "index_writer_memory");
        op.add(Builder::indexWriterMemoryInBytes, JsonpDeserializer.longDeserializer(), "index_writer_memory_in_bytes");
        op.add(Builder::maxUnsafeAutoIdTimestamp, JsonpDeserializer.longDeserializer(), "max_unsafe_auto_id_timestamp");
        op.add(Builder::memory, JsonpDeserializer.stringDeserializer(), "memory");
        op.add(Builder::memoryInBytes, JsonpDeserializer.longDeserializer(), "memory_in_bytes");
        op.add(Builder::normsMemory, JsonpDeserializer.stringDeserializer(), "norms_memory");
        op.add(Builder::normsMemoryInBytes, JsonpDeserializer.longDeserializer(), "norms_memory_in_bytes");
        op.add(Builder::pointsMemory, JsonpDeserializer.stringDeserializer(), "points_memory");
        op.add(Builder::pointsMemoryInBytes, JsonpDeserializer.longDeserializer(), "points_memory_in_bytes");
        op.add(Builder::storedFieldsMemoryInBytes, JsonpDeserializer.longDeserializer(), "stored_fields_memory_in_bytes");
        op.add(Builder::storedFieldsMemory, JsonpDeserializer.stringDeserializer(), "stored_fields_memory");
        op.add(Builder::termsMemoryInBytes, JsonpDeserializer.longDeserializer(), "terms_memory_in_bytes");
        op.add(Builder::termsMemory, JsonpDeserializer.stringDeserializer(), "terms_memory");
        op.add(Builder::termVectorsMemory, JsonpDeserializer.stringDeserializer(), "term_vectors_memory");
        op.add(Builder::termVectorsMemoryInBytes, JsonpDeserializer.longDeserializer(), "term_vectors_memory_in_bytes");
        op.add(Builder::versionMapMemory, JsonpDeserializer.stringDeserializer(), "version_map_memory");
        op.add(Builder::versionMapMemoryInBytes, JsonpDeserializer.longDeserializer(), "version_map_memory_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SegmentsStats> {
        private Integer count;
        @Nullable
        private String docValuesMemory;
        private Long docValuesMemoryInBytes;
        private Map<String, ShardFileSizeInfo> fileSizes;
        @Nullable
        private String fixedBitSet;
        private Long fixedBitSetMemoryInBytes;
        @Nullable
        private String indexWriterMemory;
        private Long indexWriterMemoryInBytes;
        private Long maxUnsafeAutoIdTimestamp;
        @Nullable
        private String memory;
        private Long memoryInBytes;
        @Nullable
        private String normsMemory;
        private Long normsMemoryInBytes;
        @Nullable
        private String pointsMemory;
        private Long pointsMemoryInBytes;
        private Long storedFieldsMemoryInBytes;
        @Nullable
        private String storedFieldsMemory;
        private Long termsMemoryInBytes;
        @Nullable
        private String termsMemory;
        @Nullable
        private String termVectorsMemory;
        private Long termVectorsMemoryInBytes;
        @Nullable
        private String versionMapMemory;
        private Long versionMapMemoryInBytes;

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder docValuesMemory(@Nullable String value) {
            this.docValuesMemory = value;
            return this;
        }

        public final Builder docValuesMemoryInBytes(long value) {
            this.docValuesMemoryInBytes = value;
            return this;
        }

        public final Builder fileSizes(Map<String, ShardFileSizeInfo> map) {
            this.fileSizes = Builder._mapPutAll(this.fileSizes, map);
            return this;
        }

        public final Builder fileSizes(String key, ShardFileSizeInfo value) {
            this.fileSizes = Builder._mapPut(this.fileSizes, key, value);
            return this;
        }

        public final Builder fileSizes(String key, Function<ShardFileSizeInfo.Builder, ObjectBuilder<ShardFileSizeInfo>> fn) {
            return this.fileSizes(key, fn.apply(new ShardFileSizeInfo.Builder()).build());
        }

        public final Builder fixedBitSet(@Nullable String value) {
            this.fixedBitSet = value;
            return this;
        }

        public final Builder fixedBitSetMemoryInBytes(long value) {
            this.fixedBitSetMemoryInBytes = value;
            return this;
        }

        public final Builder indexWriterMemory(@Nullable String value) {
            this.indexWriterMemory = value;
            return this;
        }

        public final Builder indexWriterMemoryInBytes(long value) {
            this.indexWriterMemoryInBytes = value;
            return this;
        }

        public final Builder maxUnsafeAutoIdTimestamp(long value) {
            this.maxUnsafeAutoIdTimestamp = value;
            return this;
        }

        public final Builder memory(@Nullable String value) {
            this.memory = value;
            return this;
        }

        public final Builder memoryInBytes(long value) {
            this.memoryInBytes = value;
            return this;
        }

        public final Builder normsMemory(@Nullable String value) {
            this.normsMemory = value;
            return this;
        }

        public final Builder normsMemoryInBytes(long value) {
            this.normsMemoryInBytes = value;
            return this;
        }

        public final Builder pointsMemory(@Nullable String value) {
            this.pointsMemory = value;
            return this;
        }

        public final Builder pointsMemoryInBytes(long value) {
            this.pointsMemoryInBytes = value;
            return this;
        }

        public final Builder storedFieldsMemoryInBytes(long value) {
            this.storedFieldsMemoryInBytes = value;
            return this;
        }

        public final Builder storedFieldsMemory(@Nullable String value) {
            this.storedFieldsMemory = value;
            return this;
        }

        public final Builder termsMemoryInBytes(long value) {
            this.termsMemoryInBytes = value;
            return this;
        }

        public final Builder termsMemory(@Nullable String value) {
            this.termsMemory = value;
            return this;
        }

        public final Builder termVectorsMemory(@Nullable String value) {
            this.termVectorsMemory = value;
            return this;
        }

        public final Builder termVectorsMemoryInBytes(long value) {
            this.termVectorsMemoryInBytes = value;
            return this;
        }

        public final Builder versionMapMemory(@Nullable String value) {
            this.versionMapMemory = value;
            return this;
        }

        public final Builder versionMapMemoryInBytes(long value) {
            this.versionMapMemoryInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SegmentsStats build() {
            this._checkSingleUse();
            return new SegmentsStats(this);
        }
    }
}

