/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.SparseEmbeddingResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SparseEmbeddingRequest
extends RequestBase
implements JsonpSerializable {
    private final String inferenceId;
    private final List<String> input;
    @Nullable
    private final JsonData taskSettings;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<SparseEmbeddingRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SparseEmbeddingRequest::setupSparseEmbeddingRequestDeserializer);
    public static final Endpoint<SparseEmbeddingRequest, SparseEmbeddingResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SparseEmbeddingRequest, SparseEmbeddingResponse>("es/inference.sparse_embedding", request -> "POST", request -> {
        boolean _inferenceId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/sparse_embedding");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.inferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _inferenceId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("inferenceId", request.inferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, SparseEmbeddingResponse._DESERIALIZER);

    private SparseEmbeddingRequest(Builder builder) {
        this.inferenceId = ApiTypeHelper.requireNonNull(builder.inferenceId, this, "inferenceId");
        this.input = ApiTypeHelper.unmodifiableRequired(builder.input, (Object)this, "input");
        this.taskSettings = builder.taskSettings;
        this.timeout = builder.timeout;
    }

    public static SparseEmbeddingRequest of(Function<Builder, ObjectBuilder<SparseEmbeddingRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    public final List<String> input() {
        return this.input;
    }

    @Nullable
    public final JsonData taskSettings() {
        return this.taskSettings;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.input)) {
            generator.writeKey("input");
            generator.writeStartArray();
            for (String item0 : this.input) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    protected static void setupSparseEmbeddingRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::input, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "input");
        op.add(Builder::taskSettings, JsonData._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SparseEmbeddingRequest> {
        private String inferenceId;
        private List<String> input;
        @Nullable
        private JsonData taskSettings;
        @Nullable
        private Time timeout;

        public final Builder inferenceId(String value) {
            this.inferenceId = value;
            return this;
        }

        public final Builder input(List<String> list) {
            this.input = Builder._listAddAll(this.input, list);
            return this;
        }

        public final Builder input(String value, String ... values) {
            this.input = Builder._listAdd(this.input, value, values);
            return this;
        }

        public final Builder taskSettings(@Nullable JsonData value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SparseEmbeddingRequest build() {
            this._checkSingleUse();
            return new SparseEmbeddingRequest(this);
        }
    }
}

