/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class ProcessorBase
implements JsonpSerializable {
    @Nullable
    private final String description;
    @Nullable
    private final String if_;
    @Nullable
    private final Boolean ignoreFailure;
    private final List<Processor> onFailure;
    @Nullable
    private final String tag;

    protected ProcessorBase(AbstractBuilder<?> builder) {
        this.description = ((AbstractBuilder)builder).description;
        this.if_ = ((AbstractBuilder)builder).if_;
        this.ignoreFailure = ((AbstractBuilder)builder).ignoreFailure;
        this.onFailure = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).onFailure);
        this.tag = ((AbstractBuilder)builder).tag;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final String if_() {
        return this.if_;
    }

    @Nullable
    public final Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    public final List<Processor> onFailure() {
        return this.onFailure;
    }

    @Nullable
    public final String tag() {
        return this.tag;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.if_ != null) {
            generator.writeKey("if");
            generator.write(this.if_);
        }
        if (this.ignoreFailure != null) {
            generator.writeKey("ignore_failure");
            generator.write(this.ignoreFailure.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.onFailure)) {
            generator.writeKey("on_failure");
            generator.writeStartArray();
            for (Processor item0 : this.onFailure) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupProcessorBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(AbstractBuilder::if_, JsonpDeserializer.stringDeserializer(), "if");
        op.add(AbstractBuilder::ignoreFailure, JsonpDeserializer.booleanDeserializer(), "ignore_failure");
        op.add(AbstractBuilder::onFailure, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "on_failure");
        op.add(AbstractBuilder::tag, JsonpDeserializer.stringDeserializer(), "tag");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private String description;
        @Nullable
        private String if_;
        @Nullable
        private Boolean ignoreFailure;
        @Nullable
        private List<Processor> onFailure;
        @Nullable
        private String tag;

        public final BuilderT description(@Nullable String value) {
            this.description = value;
            return (BuilderT)this.self();
        }

        public final BuilderT if_(@Nullable String value) {
            this.if_ = value;
            return (BuilderT)this.self();
        }

        public final BuilderT ignoreFailure(@Nullable Boolean value) {
            this.ignoreFailure = value;
            return (BuilderT)this.self();
        }

        public final BuilderT onFailure(List<Processor> list) {
            this.onFailure = AbstractBuilder._listAddAll(this.onFailure, list);
            return (BuilderT)this.self();
        }

        public final BuilderT onFailure(Processor value, Processor ... values) {
            this.onFailure = AbstractBuilder._listAdd(this.onFailure, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT onFailure(ProcessorVariant value, ProcessorVariant ... values) {
            this.onFailure = AbstractBuilder._listAdd(this.onFailure, value._toProcessor(), new Processor[0]);
            for (ProcessorVariant v : values) {
                AbstractBuilder._listAdd(this.onFailure, v._toProcessor(), new Processor[0]);
            }
            return (BuilderT)this.self();
        }

        public final BuilderT onFailure(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.onFailure(fn.apply(new Processor.Builder()).build(), new Processor[0]);
        }

        public final BuilderT tag(@Nullable String value) {
            this.tag = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

