/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.binding.listener;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingQueue;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingReportAction;
import org.exoplatform.social.core.binding.model.UserSpaceBinding;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SpaceBindingMembershipGroupEventListener
extends MembershipEventListener {
    private static final Log LOG = ExoLogger.getLogger(SpaceBindingMembershipGroupEventListener.class);
    private GroupSpaceBindingService groupSpaceBindingService;
    private SpaceService spaceService;
    private OrganizationService organizationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(Membership m, boolean isNew) throws Exception {
        String userName = m.getUserName();
        String groupId = m.getGroupId();
        if (isNew && !this.isASpaceGroup(groupId)) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                if (this.isActive(userName) && this.isUserNewMemberToGroup(userName, groupId)) {
                    this.groupSpaceBindingService = (GroupSpaceBindingService)CommonsUtils.getService(GroupSpaceBindingService.class);
                    this.spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
                    List<Long> removedSpaceBindingsIds = this.groupSpaceBindingService.getGroupSpaceBindingsFromQueueByAction(GroupSpaceBindingQueue.ACTION_REMOVE).stream().map(groupSpaceBinding -> groupSpaceBinding.getId()).toList();
                    List<GroupSpaceBinding> groupSpaceBindings = this.groupSpaceBindingService.findGroupSpaceBindingsByGroup(m.getGroupId());
                    if (removedSpaceBindingsIds.size() > 0 && groupSpaceBindings.size() > 0) {
                        groupSpaceBindings.removeIf(spaceBinding -> removedSpaceBindingsIds.contains(spaceBinding.getId()));
                    }
                    for (GroupSpaceBinding groupSpaceBinding2 : groupSpaceBindings) {
                        Space space = this.spaceService.getSpaceById(groupSpaceBinding2.getSpaceId());
                        long startTime = System.currentTimeMillis();
                        GroupSpaceBindingReportAction bindingReportAddSynchronizeAction = this.groupSpaceBindingService.findGroupSpaceBindingReportAction(groupSpaceBinding2.getId(), "SYNCHRONIZE");
                        if (bindingReportAddSynchronizeAction == null) {
                            GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(groupSpaceBinding2.getId(), Long.parseLong(groupSpaceBinding2.getSpaceId()), groupSpaceBinding2.getGroup(), "SYNCHRONIZE");
                            bindingReportAddSynchronizeAction = this.groupSpaceBindingService.saveGroupSpaceBindingReport(report);
                        }
                        this.groupSpaceBindingService.saveUserBinding(userName, groupSpaceBinding2, space, bindingReportAddSynchronizeAction);
                        bindingReportAddSynchronizeAction.setEndDate(new Date());
                        this.groupSpaceBindingService.updateGroupSpaceBindingReportAction(bindingReportAddSynchronizeAction);
                        long totalTime = System.currentTimeMillis() - startTime;
                        LOG.info("service={} operation={} parameters=\"space:{},totalSpaceMembers:{},boundSpaceMembers:{}\" status=ok duration_ms={}", new Object[]{"group-binding", "update-binding", space.getPrettyName(), space.getMembers().length, this.groupSpaceBindingService.countBoundUsers(space.getId()), totalTime});
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Problem occurred when saving user bindings for user ({}) from group ({}): ", new Object[]{userName, groupId, e});
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    private boolean isActive(String userName) throws Exception {
        this.organizationService = CommonsUtils.getOrganizationService();
        return this.organizationService.getUserHandler().findUserByName(userName, UserStatus.ENABLED) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelete(Membership m) throws Exception {
        String userName = m.getUserName();
        String groupId = m.getGroupId();
        if (!this.isASpaceGroup(groupId)) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                if (this.isActive(userName) && this.isUserNoMoreMemberOfGroup(userName, groupId)) {
                    this.groupSpaceBindingService = (GroupSpaceBindingService)CommonsUtils.getService(GroupSpaceBindingService.class);
                    this.spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
                    List<UserSpaceBinding> userSpaceBindings = this.groupSpaceBindingService.findUserBindingsByGroup(m.getGroupId(), m.getUserName());
                    for (UserSpaceBinding userSpaceBinding : userSpaceBindings) {
                        GroupSpaceBinding binding = userSpaceBinding.getGroupBinding();
                        Space space = this.spaceService.getSpaceById(binding.getSpaceId());
                        long startTime = System.currentTimeMillis();
                        GroupSpaceBindingReportAction bindingReportAddSynchronizeAction = this.groupSpaceBindingService.findGroupSpaceBindingReportAction(binding.getId(), "SYNCHRONIZE");
                        if (bindingReportAddSynchronizeAction == null) {
                            GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(binding.getId(), Long.parseLong(binding.getSpaceId()), binding.getGroup(), "SYNCHRONIZE");
                            bindingReportAddSynchronizeAction = this.groupSpaceBindingService.saveGroupSpaceBindingReport(report);
                        }
                        this.groupSpaceBindingService.deleteUserBinding(userSpaceBinding, bindingReportAddSynchronizeAction);
                        bindingReportAddSynchronizeAction.setEndDate(new Date());
                        this.groupSpaceBindingService.updateGroupSpaceBindingReportAction(bindingReportAddSynchronizeAction);
                        long totalTime = System.currentTimeMillis() - startTime;
                        LOG.info("service={} operation={} parameters=\"space:{},totalSpaceMembers:{},boundSpaceMembers:{}\" status=ok duration_ms={}", new Object[]{"group-binding", "update-binding", space.getPrettyName(), space.getMembers().length, this.groupSpaceBindingService.countBoundUsers(space.getId()), totalTime});
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Problem occurred when removing user bindings for user ({}): ", new Object[]{userName, e});
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    private boolean isASpaceGroup(String groupName) {
        return groupName.startsWith("/spaces");
    }

    private boolean isUserNoMoreMemberOfGroup(String userName, String groupId) throws Exception {
        this.organizationService = CommonsUtils.getOrganizationService();
        Collection userMemberships = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(userName, groupId);
        return userMemberships.isEmpty();
    }

    private boolean isUserNewMemberToGroup(String userName, String groupId) throws Exception {
        this.organizationService = CommonsUtils.getOrganizationService();
        Collection userMemberships = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(userName, groupId);
        return userMemberships.size() == 1;
    }
}

