/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.insert;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.update.Assignment;

public class ConflictClause {
    private final @Nullable String constraintName;
    private final List<String> constraintColumnNames;
    private final List<Assignment> assignments;
    private final @Nullable Predicate predicate;

    public ConflictClause(@Nullable String constraintName, List<String> constraintColumnNames, List<Assignment> assignments, @Nullable Predicate predicate) {
        this.constraintName = constraintName;
        this.constraintColumnNames = constraintColumnNames;
        this.assignments = assignments;
        this.predicate = predicate;
    }

    public @Nullable String getConstraintName() {
        return this.constraintName;
    }

    public List<String> getConstraintColumnNames() {
        return this.constraintColumnNames;
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public boolean isDoNothing() {
        return this.assignments.isEmpty();
    }

    public boolean isDoUpdate() {
        return !this.assignments.isEmpty();
    }

    public @Nullable Predicate getPredicate() {
        return this.predicate;
    }
}

