/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging.mdc.customobjects;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.logging.mdc.CustomMdcObject;
import lombok.Generated;

public class ChangesetsRolledback
implements CustomMdcObject {
    private int changesetCount;
    private List<ChangeSet> changesets;

    public ChangesetsRolledback() {
    }

    public ChangesetsRolledback(List<ChangeSet> changeSets) {
        this.changesetCount = changeSets.size();
        this.changesets = changeSets;
    }

    public static ChangesetsRolledback fromChangesetList(List<liquibase.changelog.ChangeSet> changeSets) {
        if (changeSets != null) {
            List<ChangeSet> changesets = changeSets.stream().map(ChangeSet::fromChangeSet).collect(Collectors.toList());
            return new ChangesetsRolledback(changesets);
        }
        return new ChangesetsRolledback(Collections.emptyList());
    }

    @Generated
    public int getChangesetCount() {
        return this.changesetCount;
    }

    @Generated
    public List<ChangeSet> getChangesets() {
        return this.changesets;
    }

    @Generated
    public void setChangesetCount(int changesetCount) {
        this.changesetCount = changesetCount;
    }

    @Generated
    public void setChangesets(List<ChangeSet> changesets) {
        this.changesets = changesets;
    }

    public static class ChangeSet {
        private String changesetId;
        private String author;
        private String filepath;
        private String deploymentId;

        public ChangeSet(String changesetId, String author, String filepath, String deploymentId) {
            this.changesetId = changesetId;
            this.author = author;
            this.filepath = filepath;
            this.deploymentId = deploymentId;
        }

        public static ChangeSet fromChangeSet(liquibase.changelog.ChangeSet changeSet) {
            return new ChangeSet(changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath(), changeSet.getDeploymentId());
        }

        @Generated
        public String getChangesetId() {
            return this.changesetId;
        }

        @Generated
        public String getAuthor() {
            return this.author;
        }

        @Generated
        public String getFilepath() {
            return this.filepath;
        }

        @Generated
        public String getDeploymentId() {
            return this.deploymentId;
        }

        @Generated
        public void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Generated
        public void setAuthor(String author) {
            this.author = author;
        }

        @Generated
        public void setFilepath(String filepath) {
            this.filepath = filepath;
        }

        @Generated
        public void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }
    }
}

