/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreImportService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;

public class SynchronizedUserProfileListener
extends Listener<IDMExternalStoreImportService, Map<String, String>> {
    public void onEvent(Event<IDMExternalStoreImportService, Map<String, String>> event) throws Exception {
        Map userPropertiesMap = (Map)event.getData();
        String userName = (String)userPropertiesMap.get("username");
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", userName);
        if (userIdentity != null) {
            Profile profile = userIdentity.getProfile();
            Map internalUserProperties = profile.getProperties();
            Map<String, Object> externalUserProperties = this.buildProfilePropertiesMap(userPropertiesMap);
            boolean isModified = false;
            Set<String> externalUserProfileAttributes = externalUserProperties.keySet();
            for (String externalUserProfileAttribute : externalUserProfileAttributes) {
                if (internalUserProperties.containsKey(externalUserProfileAttribute) && Objects.equals(externalUserProperties.get(externalUserProfileAttribute), internalUserProperties.get(externalUserProfileAttribute))) continue;
                profile.setProperty(externalUserProfileAttribute, externalUserProperties.get(externalUserProfileAttribute));
                isModified = true;
            }
            if (isModified) {
                identityManager.updateProfile(this.cleanProfilePropertySetting(profile), true);
            }
        }
    }

    private Map<String, Object> buildProfilePropertiesMap(Map<String, String> externalUserPropertiesMap) {
        HashMap<String, Object> proprtiesMap = new HashMap<String, Object>();
        ProfilePropertyService profilePropertyService = (ProfilePropertyService)CommonsUtils.getService(ProfilePropertyService.class);
        List profilePropertySettingNames = profilePropertyService.getPropertySettingNames();
        for (Map.Entry<String, String> entry : externalUserPropertiesMap.entrySet()) {
            ProfilePropertySetting propertySetting;
            String name = entry.getKey();
            String value = entry.getValue();
            if (!profilePropertySettingNames.contains(name) && (!name.contains(".") || !profilePropertySettingNames.contains(name.substring(0, name.indexOf(46))))) continue;
            ProfilePropertySetting profilePropertySetting = propertySetting = name.contains(".") ? profilePropertyService.getProfileSettingByName(name.substring(0, name.indexOf(46))) : null;
            if (propertySetting == null) {
                propertySetting = profilePropertyService.getProfileSettingByName(name);
            }
            if (propertySetting == null) continue;
            String propertyName = propertySetting.getPropertyName();
            List<String> systemMultivaluedFields = Arrays.asList("user", "phones", "ims");
            if (systemMultivaluedFields.contains(propertyName)) {
                List maps = !proprtiesMap.containsKey(propertyName) ? new ArrayList() : (List)proprtiesMap.get(propertyName);
                HashMap<String, String> childProperty = new HashMap<String, String>();
                childProperty.put("key", name);
                childProperty.put("value", value);
                maps.add(childProperty);
                proprtiesMap.put(propertyName, maps);
                continue;
            }
            if (propertySetting.isMultiValued() && value.matches("^\\[(.*)\\]$")) {
                String[] valuesArray;
                ArrayList multivaluedPropsList = new ArrayList();
                for (String valueString : valuesArray = value.substring(1, value.length() - 1).split(",")) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    if (!StringUtils.isNotBlank((CharSequence)valueString)) continue;
                    map.put("value", valueString.trim());
                    multivaluedPropsList.add(map);
                }
                proprtiesMap.put(name, multivaluedPropsList);
                continue;
            }
            proprtiesMap.put(name, value);
        }
        return proprtiesMap;
    }

    private Profile cleanProfilePropertySetting(Profile internalProfile) {
        Iterator iterator = internalProfile.getProperties().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.contains(".") || key.split(".").length >= 2) continue;
            String parentfield = key.substring(0, key.indexOf(46));
            if (!internalProfile.getProperties().containsKey(parentfield)) continue;
            iterator.remove();
        }
        return internalProfile;
    }
}

