/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.component;

import java.util.ArrayList;
import java.util.List;

public class ThreadContext {
    private final ThreadLocal<Object>[] threadLocals;
    private Object[] values;
    private Object[] oldValues;

    public ThreadContext(ThreadLocal<?> ... threadLocals) {
        this.threadLocals = threadLocals;
    }

    private ThreadContext(List<ThreadContext> contexts) {
        if (contexts == null) {
            this.threadLocals = null;
            return;
        }
        ArrayList<ThreadLocal<Object>> lThreadLocals = new ArrayList<ThreadLocal<Object>>();
        int length = contexts.size();
        for (int i = 0; i < length; ++i) {
            ThreadContext ctx = contexts.get(i);
            if (ctx == null || ctx.threadLocals == null || ctx.threadLocals.length == 0) continue;
            for (int j = 0; j < ctx.threadLocals.length; ++j) {
                ThreadLocal<Object> tl = ctx.threadLocals[j];
                if (tl == null) continue;
                lThreadLocals.add(tl);
            }
        }
        this.threadLocals = lThreadLocals.toArray(new ThreadLocal[lThreadLocals.size()]);
    }

    public static ThreadContext merge(List<ThreadContext> contexts) {
        return new ThreadContext(contexts);
    }

    public void store() {
        this.values = new Object[this.threadLocals == null ? 0 : this.threadLocals.length];
        for (int i = 0; i < this.values.length; ++i) {
            ThreadLocal<Object> tl = this.threadLocals[i];
            if (tl == null) continue;
            this.values[i] = tl.get();
        }
    }

    public void push() {
        if (this.values == null) {
            throw new IllegalStateException("No values have been set, the store method has not been called or failed");
        }
        this.oldValues = new Object[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            ThreadLocal<Object> tl = this.threadLocals[i];
            if (tl == null) continue;
            this.oldValues[i] = tl.get();
            tl.set(this.values[i]);
        }
        this.values = null;
    }

    public void restore() {
        if (this.oldValues == null) {
            throw new IllegalStateException("No old values have been set, the push method has not been called or failed");
        }
        for (int i = 0; i < this.oldValues.length; ++i) {
            ThreadLocal<Object> tl = this.threadLocals[i];
            if (tl == null) continue;
            tl.set(this.oldValues[i]);
        }
        this.oldValues = null;
    }
}

