/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.security.rest;

import io.meeds.web.security.service.ApiKeyService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/apiKey"})
@Tag(name="/apiKey", description="Manage User API Keys")
public class ApiKeyRest {
    @Autowired
    private ApiKeyService apiKeyService;

    @Secured(value={"users"})
    @GetMapping
    @Operation(summary="Retrieves clear password for current user if OTP is valid", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fullfilled")})
    public boolean hasPassword(HttpServletRequest request) {
        return this.apiKeyService.getPassword(request.getRemoteUser()) != null;
    }

    @Secured(value={"users"})
    @PostMapping(consumes={"application/x-www-form-urlencoded"})
    @Operation(summary="Retrieves clear password for current user if OTP is valid", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fullfilled")})
    public String getPassword(HttpServletRequest request, @Parameter(description="OTP Method") @RequestParam(value="method") String otpMethod, @Parameter(description="OTP Code") @RequestParam(value="code") String otpCode, @Parameter(description="Whether to renew API Key or not. Possible values: true or false") @RequestParam(value="renew", required=false, defaultValue="false") boolean renew) {
        try {
            return this.apiKeyService.getPassword(request.getRemoteUser(), otpMethod, otpCode, renew);
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }
}

