/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.service;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.crypto.CryptoUtils;
import org.web3j.crypto.ECDSASignature;
import org.web3j.crypto.HSMHTTPPass;
import org.web3j.crypto.Sign;
import org.web3j.protocol.exceptions.ClientConnectionException;
import org.web3j.service.HSMRequestProcessor;
import org.web3j.utils.Numeric;

public abstract class HSMHTTPRequestProcessor<T extends HSMHTTPPass>
implements HSMRequestProcessor<HSMHTTPPass> {
    private static final Logger log = LoggerFactory.getLogger(HSMHTTPRequestProcessor.class);
    public static final MediaType JSON = MediaType.parse((String)"application/json");
    private final OkHttpClient client;

    public HSMHTTPRequestProcessor(OkHttpClient okHttpClient) {
        this.client = okHttpClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Sign.SignatureData callHSM(byte[] dataToSign, HSMHTTPPass pass) {
        Request request = this.createRequest(dataToSign, pass);
        try (Response response = this.client.newCall(request).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                if (responseBody != null) {
                    String signHex = this.readResponse(responseBody.byteStream());
                    byte[] signBytes = Numeric.hexStringToByteArray((String)signHex);
                    ECDSASignature signature = CryptoUtils.fromDerFormat((byte[])signBytes);
                    Sign.SignatureData signatureData = Sign.createSignatureData((ECDSASignature)signature, (BigInteger)pass.getPublicKey(), (byte[])dataToSign);
                    return signatureData;
                }
                Sign.SignatureData signHex = null;
                return signHex;
            }
            int code = response.code();
            String text = responseBody == null ? "N/A" : responseBody.string();
            throw new ClientConnectionException("Invalid response received: " + code + "; " + text);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected abstract Request createRequest(byte[] var1, HSMHTTPPass var2);

    protected abstract String readResponse(InputStream var1);
}

