/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.activity.plugin;

import io.meeds.social.category.model.CategoryObject;
import io.meeds.social.category.plugin.CategoryPlugin;
import java.util.List;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityCategoryPlugin
implements CategoryPlugin {
    public static final String OBJECT_TYPE = "activity";
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private UserACL userAcl;

    public String getType() {
        return OBJECT_TYPE;
    }

    public boolean canAccess(String activityId, String username) {
        return this.userAcl.hasAccessPermission(OBJECT_TYPE, activityId, username);
    }

    public boolean canEdit(String activityId, String username) {
        return this.userAcl.hasPermission(OBJECT_TYPE, activityId, "manage", username);
    }

    public List<Long> getCategoryIds() {
        return this.getCategoryIds(0L);
    }

    public List<Long> getCategoryIds(long spaceId) {
        return this.activityManager.getActivityCategoryIds(spaceId);
    }

    public CategoryObject getObject(CategoryObject categoryObject) {
        ExoSocialActivity activity = this.activityManager.getActivity(categoryObject.getId());
        return activity == null ? categoryObject : new CategoryObject(activity.getMetadataObject());
    }
}

