/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.activity.plugin;

import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import io.meeds.social.html.utils.HtmlUtils;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.filter.ActivitySearchFilter;
import org.exoplatform.social.core.activity.model.ActivitySearchResult;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.jpa.search.ActivitySearchConnector;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.jsoup.Jsoup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityContentLinkPlugin
implements ContentLinkPlugin {
    public static final String OBJECT_TYPE = "activity";
    private static final String TITLE_KEY = "contentLink.activity";
    private static final String ICON = "fa fa-stream";
    private static final String COMMAND = "post";
    private static final int MAX_TITLE_LENGTH = 50;
    private static final ContentLinkExtension EXTENSION = new ContentLinkExtension("activity", "contentLink.activity", "fa fa-stream", "post");
    @Autowired
    private ContentLinkPluginService contentLinkPluginService;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private ActivitySearchConnector activitySearchConnector;

    @PostConstruct
    public void init() {
        this.contentLinkPluginService.addPlugin((ContentLinkPlugin)this);
    }

    public ContentLinkExtension getExtension() {
        return EXTENSION;
    }

    public List<ContentLinkSearchResult> search(String keyword, Identity identity, Locale locale, int offset, int limit) {
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.userAcl.isAnonymousUser(identity) ? null : this.identityManager.getOrCreateUserIdentity(identity.getUserId());
        List<ActivitySearchResult> results = this.activitySearchConnector.search(userIdentity, new ActivitySearchFilter(keyword), offset, limit);
        return results.stream().map(searchResult -> this.toContentLink((ActivitySearchResult)searchResult, identity)).filter(Objects::nonNull).toList();
    }

    public String getContentTitle(String objectId, Locale locale) {
        ExoSocialActivity activity = this.activityManager.getActivity(objectId);
        return activity == null ? null : this.getActivityTitle(activity);
    }

    private ContentLinkSearchResult toContentLink(ActivitySearchResult searchResult, Identity identity) {
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(searchResult.getId()));
        if (activity == null) {
            return null;
        }
        return new ContentLinkSearchResult(OBJECT_TYPE, String.valueOf(searchResult.getId()), this.getActivityTitle(activity), EXTENSION.getIcon());
    }

    private String getActivityTitle(ExoSocialActivity activity) {
        String content = this.activityManager.getActivityTitle(activity);
        if (!StringUtils.contains((CharSequence)content, (CharSequence)String.format("%s:%s", OBJECT_TYPE, activity.getId()))) {
            content = HtmlUtils.transform(content, null);
        }
        return content == null ? "" : StringUtils.abbreviate((String)Jsoup.parse((String)content).text(), (int)50);
    }
}

