/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.listener;

import io.meeds.social.category.model.CategoryObject;
import io.meeds.social.category.service.CategoryLinkService;
import io.meeds.social.space.category.service.SpaceCategoryService;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CategoryLinkModifiedListener
implements ListenerBase<Long, CategoryObject> {
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private SpaceCategoryService spaceCategoryService;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private CategoryLinkService categoryLinkService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("category.link.added", (ListenerBase)this);
        this.listenerService.addListener("category.link.removed", (ListenerBase)this);
    }

    public void onEvent(Event<Long, CategoryObject> event) throws Exception {
        String type;
        CategoryObject object = (CategoryObject)event.getData();
        switch (type = object.getType()) {
            case "space": {
                List categoryIds;
                Space space = this.spaceService.getSpaceById(Long.parseLong(object.getId()));
                if (space == null || CollectionUtils.size((Object)(categoryIds = this.spaceCategoryService.getSpaceCategoryIds(space.getSpaceId()))) == CollectionUtils.size((Object)space.getCategoryIds()) && (CollectionUtils.size((Object)categoryIds) <= 0 || CollectionUtils.isEqualCollection((Collection)categoryIds, (Collection)space.getCategoryIds()))) break;
                space.setCategoryIds(categoryIds);
                this.spaceService.updateSpace(space);
                break;
            }
            case "activity": {
                String activityId = object.getId();
                ExoSocialActivity activity = this.activityManager.getActivity(activityId);
                if (activity == null) break;
                List categoryIds = this.categoryLinkService.getLinkedIds(new CategoryObject(activity.getMetadataObject()));
                if (CollectionUtils.size((Object)activity.getCategoryIds()) == CollectionUtils.size((Object)categoryIds) && (CollectionUtils.size((Object)categoryIds) <= 0 || CollectionUtils.isEqualCollection((Collection)categoryIds, (Collection)activity.getCategoryIds()))) break;
                activity.setCategoryIds(categoryIds);
                this.activityManager.updateActivity(activity);
                break;
            }
        }
    }
}

