/*
 * Decompiled with CFR 0.152.
 */
package liquibase.precondition.core;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.precondition.AbstractPrecondition;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ForeignKeyExistsPrecondition
extends AbstractPrecondition {
    private String catalogName;
    private String schemaName;
    private String foreignKeyTableName;
    private String foreignKeyName;

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    @Override
    public Warnings warn(Database database) {
        return new Warnings();
    }

    @Override
    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    @Override
    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet, ChangeExecListener changeExecListener) throws PreconditionFailedException, PreconditionErrorException {
        try {
            ForeignKey example = new ForeignKey();
            example.setName(this.getForeignKeyName());
            example.setForeignKeyTable(new Table());
            if (StringUtils.trimToNull((String)this.getForeignKeyTableName()) != null) {
                example.getForeignKeyTable().setName(this.getForeignKeyTableName());
            }
            String catalogName = this.getCatalogName() != null ? this.getCatalogName() : database.getDefaultCatalogName();
            String schemaName = this.getSchemaName() != null ? this.getSchemaName() : database.getDefaultSchemaName();
            example.getForeignKeyTable().setSchema(new Schema(catalogName, schemaName));
            if (!SnapshotGeneratorFactory.getInstance().hasIgnoreNested(example, database)) {
                throw new PreconditionFailedException("Foreign Key " + database.escapeIndexName(catalogName, schemaName, this.foreignKeyName) + " does not exist", changeLog, this);
            }
        }
        catch (PreconditionFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PreconditionErrorException(e, changeLog, this);
        }
    }

    @Override
    public String getName() {
        return "foreignKeyConstraintExists";
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setForeignKeyTableName(String foreignKeyTableName) {
        this.foreignKeyTableName = foreignKeyTableName;
    }

    @Generated
    public void setForeignKeyName(String foreignKeyName) {
        this.foreignKeyName = foreignKeyName;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getForeignKeyTableName() {
        return this.foreignKeyTableName;
    }

    @Generated
    public String getForeignKeyName() {
        return this.foreignKeyName;
    }
}

