/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource.config.tasks;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.exoplatform.portal.resource.SkinDependentManager;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.config.tasks.AbstractSkinModule;
import org.exoplatform.portal.resource.config.tasks.SkinConfigTask;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PortletSkinTask
extends AbstractSkinModule
implements SkinConfigTask {
    protected static final Log LOG = ExoLogger.getLogger(PortletSkinTask.class);
    private String applicationName;
    private String portletName;
    private List<String> additionalModules;

    public PortletSkinTask() {
        super(null);
        this.overwrite = true;
    }

    @Override
    public void execute(SkinService skinService, ServletContext scontext) {
        int priority;
        if (this.portletName == null) {
            return;
        }
        if (this.skinName == null) {
            this.skinName = skinService.getDefaultSkin();
        }
        if (this.applicationName == null) {
            this.applicationName = scontext.getContextPath();
        }
        String moduleName = this.applicationName + "/" + this.portletName;
        String fullCSSPath = this.cssPath == null ? null : scontext.getContextPath() + this.cssPath;
        try {
            priority = Integer.valueOf(this.cssPriority);
        }
        catch (Exception e) {
            priority = Integer.MAX_VALUE;
        }
        skinService.addSkin(moduleName, this.skinName, fullCSSPath, priority, this.overwrite, this.additionalModules);
        this.updateSkinDependentManager("/" + this.applicationName, moduleName, this.skinName);
    }

    @Override
    public void binding(Element elemt) {
        this.bindingApplicationName(elemt);
        this.bindingPortletName(elemt);
        this.bindingCSSPath(elemt);
        this.bindingSkinName(elemt);
        this.bindingOverwrite(elemt);
        this.bindingCSSPriority(elemt);
        this.bindingAdditionalModules(elemt);
    }

    private void bindingApplicationName(Element element) {
        NodeList nodes = element.getElementsByTagName("application-name");
        if (nodes == null || nodes.getLength() < 1) {
            return;
        }
        this.applicationName = nodes.item(0).getFirstChild().getNodeValue();
    }

    private void bindingPortletName(Element element) {
        NodeList nodes = element.getElementsByTagName("portlet-name");
        if (nodes == null || nodes.getLength() < 1) {
            return;
        }
        this.portletName = nodes.item(0).getFirstChild().getNodeValue();
    }

    private void bindingAdditionalModules(Element element) {
        NodeList nodes = element.getElementsByTagName("additional-module");
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        int length = nodes.getLength();
        ArrayList<String> filteredPortalModuleNames = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            filteredPortalModuleNames.add(nodes.item(i).getFirstChild().getNodeValue());
        }
        this.additionalModules = filteredPortalModuleNames;
    }

    private void updateSkinDependentManager(String webApp, String moduleName, String skinName) {
        SkinDependentManager.addPortletSkin(webApp, moduleName, skinName);
        SkinDependentManager.addSkinDeployedInApp(webApp, skinName);
    }

    @Generated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Generated
    public String getPortletName() {
        return this.portletName;
    }

    @Generated
    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    @Generated
    public List<String> getAdditionalModules() {
        return this.additionalModules;
    }

    @Generated
    public void setAdditionalModules(List<String> additionalModules) {
        this.additionalModules = additionalModules;
    }
}

