/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.model;

import java.util.List;
import lombok.Generated;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.CacheEntry;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;

public class Space
implements CacheEntry {
    public static final String DEFAULT_SPACE_METADATA_OBJECT_TYPE = "space";
    public static final String ACTIVE_STATUS = "active";
    public static final String DEACTIVE_STATUS = "deactive";
    public static final String INSTALL_STATUS = "installed";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String HIDDEN = "hidden";
    public static final String OPEN = "open";
    public static final String VALIDATION = "validation";
    public static final String CLOSED = "closed";
    public static final String HOME_URL = "home";
    private long id;
    private String displayName;
    private String groupId;
    private boolean hasBindings;
    private String description;
    private String[] pendingUsers;
    private String[] invitedUsers;
    private long templateId;
    private boolean sovereign;
    private String url;
    private String visibility;
    private String registration;
    private AvatarAttachment avatarAttachment;
    private BannerAttachment bannerAttachment;
    private long createdTime;
    private long cacheTime;
    private long publicSiteId;
    private String publicSiteVisibility;
    private long lastUpdatedTime;
    private String prettyName;
    private String avatarUrl;
    private String bannerUrl;
    private String editor;
    private String[] managers;
    private Long avatarLastUpdated;
    private Long bannerLastUpdated;
    private String[] members;
    private String[] redactors;
    private String[] publishers;
    private List<String> layoutPermissions;
    private List<String> deletePermissions;
    private List<String> publicSitePermissions;
    private List<Long> categoryIds;
    private UpdatedField field;

    public void setLastUpdatedTime(long lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public UpdatedField getField() {
        return this.field;
    }

    public void setField(UpdatedField field) {
        this.field = field;
    }

    public void setId(String id) {
        this.id = id == null ? 0L : Long.parseLong(id);
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getId() {
        return String.valueOf(this.id);
    }

    public long getSpaceId() {
        return this.id;
    }

    public void setDisplayName(String spaceDisplayName) {
        this.displayName = spaceDisplayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setHasBindings(boolean hasBindings) {
        this.hasBindings = hasBindings;
    }

    public boolean hasBindings() {
        return this.hasBindings;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setPendingUsers(String[] pendingUsers) {
        this.pendingUsers = pendingUsers;
    }

    public String[] getPendingUsers() {
        return this.pendingUsers;
    }

    public void setInvitedUsers(String[] invitedUsers) {
        this.invitedUsers = invitedUsers;
    }

    public String[] getInvitedUsers() {
        return this.invitedUsers;
    }

    public String getShortName() {
        return this.groupId.substring(this.groupId.lastIndexOf("/") + 1);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String toString() {
        return this.displayName + " (" + this.groupId + ")";
    }

    public String getRegistration() {
        return this.registration;
    }

    public void setRegistration(String registration) {
        this.registration = registration;
    }

    public void setAvatarAttachment(AvatarAttachment avatarAttachment) {
        this.avatarAttachment = avatarAttachment;
        if (avatarAttachment != null) {
            this.setAvatarLastUpdated(avatarAttachment.getLastModified());
        } else {
            this.setAvatarLastUpdated(null);
            this.setAvatarUrl(null);
        }
    }

    public AvatarAttachment getAvatarAttachment() {
        return this.avatarAttachment;
    }

    public BannerAttachment getBannerAttachment() {
        return this.bannerAttachment;
    }

    public void setBannerAttachment(BannerAttachment bannerAttachment) {
        this.bannerAttachment = bannerAttachment;
        if (bannerAttachment != null) {
            this.setBannerLastUpdated(bannerAttachment.getLastModified());
        } else {
            this.setBannerLastUpdated(null);
            this.setBannerUrl(null);
        }
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public void setPrettyName(String prettyName) {
        this.prettyName = Utils.cleanString(prettyName);
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getBannerUrl() {
        return this.bannerUrl;
    }

    public void setBannerUrl(String bannerUrl) {
        this.bannerUrl = bannerUrl;
    }

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public String[] getManagers() {
        return this.managers;
    }

    public void setManagers(String[] managers) {
        this.managers = managers;
    }

    public String[] getMembers() {
        return this.members;
    }

    public void setMembers(String[] members) {
        this.members = members;
    }

    public String[] getRedactors() {
        return this.redactors;
    }

    public void setRedactors(String[] redactors) {
        this.redactors = redactors;
    }

    public String[] getPublishers() {
        return this.publishers;
    }

    public void setPublishers(String[] publishers) {
        this.publishers = publishers;
    }

    public Long getAvatarLastUpdated() {
        return this.avatarLastUpdated;
    }

    public void setAvatarLastUpdated(Long avatarLastUpdatedTime) {
        this.avatarLastUpdated = avatarLastUpdatedTime;
    }

    public Long getBannerLastUpdated() {
        return this.bannerLastUpdated;
    }

    public void setBannerLastUpdated(Long bannerLastUpdated) {
        this.bannerLastUpdated = bannerLastUpdated;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Long createdTime) {
        this.createdTime = createdTime != null ? createdTime : System.currentTimeMillis();
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Space)) return false;
        Space space = (Space)o;
        if (this.id != space.id) return false;
        return true;
    }

    @Generated
    public long getTemplateId() {
        return this.templateId;
    }

    @Generated
    public void setTemplateId(long templateId) {
        this.templateId = templateId;
    }

    @Generated
    public boolean isSovereign() {
        return this.sovereign;
    }

    @Generated
    public void setSovereign(boolean sovereign) {
        this.sovereign = sovereign;
    }

    @Override
    @Generated
    public long getCacheTime() {
        return this.cacheTime;
    }

    @Override
    @Generated
    public void setCacheTime(long cacheTime) {
        this.cacheTime = cacheTime;
    }

    @Generated
    public long getPublicSiteId() {
        return this.publicSiteId;
    }

    @Generated
    public void setPublicSiteId(long publicSiteId) {
        this.publicSiteId = publicSiteId;
    }

    @Generated
    public String getPublicSiteVisibility() {
        return this.publicSiteVisibility;
    }

    @Generated
    public void setPublicSiteVisibility(String publicSiteVisibility) {
        this.publicSiteVisibility = publicSiteVisibility;
    }

    @Generated
    public List<String> getLayoutPermissions() {
        return this.layoutPermissions;
    }

    @Generated
    public void setLayoutPermissions(List<String> layoutPermissions) {
        this.layoutPermissions = layoutPermissions;
    }

    @Generated
    public List<String> getDeletePermissions() {
        return this.deletePermissions;
    }

    @Generated
    public void setDeletePermissions(List<String> deletePermissions) {
        this.deletePermissions = deletePermissions;
    }

    @Generated
    public List<String> getPublicSitePermissions() {
        return this.publicSitePermissions;
    }

    @Generated
    public void setPublicSitePermissions(List<String> publicSitePermissions) {
        this.publicSitePermissions = publicSitePermissions;
    }

    @Generated
    public List<Long> getCategoryIds() {
        return this.categoryIds;
    }

    @Generated
    public void setCategoryIds(List<Long> categoryIds) {
        this.categoryIds = categoryIds;
    }

    public static enum UpdatedField {
        DESCRIPTION(true);

        private boolean type;

        private UpdatedField(boolean type) {
            this.type = type;
        }

        public boolean value() {
            return this.type;
        }
    }
}

