/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.annotation;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.Ejb3TransactionAnnotationParser;
import org.springframework.transaction.annotation.JtaTransactionAnnotationParser;
import org.springframework.transaction.annotation.SpringTransactionAnnotationParser;
import org.springframework.transaction.annotation.TransactionAnnotationParser;
import org.springframework.transaction.interceptor.AbstractFallbackTransactionAttributeSource;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class AnnotationTransactionAttributeSource
extends AbstractFallbackTransactionAttributeSource
implements Serializable {
    private static final boolean jtaPresent;
    private static final boolean ejb3Present;
    private final Set<TransactionAnnotationParser> annotationParsers;
    private boolean publicMethodsOnly = true;
    @Nullable
    private Set<RollbackRuleAttribute> defaultRollbackRules;

    public AnnotationTransactionAttributeSource() {
        if (jtaPresent || ejb3Present) {
            this.annotationParsers = CollectionUtils.newLinkedHashSet((int)3);
            this.annotationParsers.add(new SpringTransactionAnnotationParser());
            if (jtaPresent) {
                this.annotationParsers.add(new JtaTransactionAnnotationParser());
            }
            if (ejb3Present) {
                this.annotationParsers.add(new Ejb3TransactionAnnotationParser());
            }
        } else {
            this.annotationParsers = Collections.singleton(new SpringTransactionAnnotationParser());
        }
    }

    public AnnotationTransactionAttributeSource(boolean publicMethodsOnly) {
        this();
        this.publicMethodsOnly = publicMethodsOnly;
    }

    public AnnotationTransactionAttributeSource(TransactionAnnotationParser annotationParser) {
        Assert.notNull((Object)annotationParser, (String)"TransactionAnnotationParser must not be null");
        this.annotationParsers = Collections.singleton(annotationParser);
    }

    public AnnotationTransactionAttributeSource(TransactionAnnotationParser ... annotationParsers) {
        Assert.notEmpty((Object[])annotationParsers, (String)"At least one TransactionAnnotationParser needs to be specified");
        this.annotationParsers = Set.of(annotationParsers);
    }

    public void setPublicMethodsOnly(boolean publicMethodsOnly) {
        this.publicMethodsOnly = publicMethodsOnly;
    }

    public void addDefaultRollbackRule(RollbackRuleAttribute rollbackRule) {
        if (this.defaultRollbackRules == null) {
            this.defaultRollbackRules = new LinkedHashSet<RollbackRuleAttribute>();
        }
        this.defaultRollbackRules.add(rollbackRule);
    }

    @Override
    public boolean isCandidateClass(Class<?> targetClass) {
        for (TransactionAnnotationParser parser : this.annotationParsers) {
            if (!parser.isCandidateClass(targetClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected TransactionAttribute findTransactionAttribute(Class<?> clazz) {
        return this.determineTransactionAttribute(clazz);
    }

    @Override
    @Nullable
    protected TransactionAttribute findTransactionAttribute(Method method) {
        return this.determineTransactionAttribute(method);
    }

    @Nullable
    protected TransactionAttribute determineTransactionAttribute(AnnotatedElement element) {
        for (TransactionAnnotationParser parser : this.annotationParsers) {
            TransactionAttribute attr = parser.parseTransactionAnnotation(element);
            if (attr == null) continue;
            if (this.defaultRollbackRules != null && attr instanceof RuleBasedTransactionAttribute) {
                RuleBasedTransactionAttribute ruleAttr = (RuleBasedTransactionAttribute)attr;
                ruleAttr.getRollbackRules().addAll(this.defaultRollbackRules);
            }
            return attr;
        }
        return null;
    }

    @Override
    protected boolean allowPublicMethodsOnly() {
        return this.publicMethodsOnly;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof AnnotationTransactionAttributeSource)) return false;
        AnnotationTransactionAttributeSource otherTas = (AnnotationTransactionAttributeSource)other;
        if (!this.annotationParsers.equals(otherTas.annotationParsers)) return false;
        if (this.publicMethodsOnly != otherTas.publicMethodsOnly) return false;
        return true;
    }

    public int hashCode() {
        return this.annotationParsers.hashCode();
    }

    static {
        ClassLoader classLoader = AnnotationTransactionAttributeSource.class.getClassLoader();
        jtaPresent = ClassUtils.isPresent((String)"jakarta.transaction.Transactional", (ClassLoader)classLoader);
        ejb3Present = ClassUtils.isPresent((String)"jakarta.ejb.TransactionAttribute", (ClassLoader)classLoader);
    }
}

