/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.kernel;

import io.meeds.spring.kernel.KernelContainerLifecyclePlugin;
import jakarta.servlet.ServletContext;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.context.ApplicationContext;

public class PortalApplicationContext
extends AnnotationConfigServletWebServerApplicationContext {
    private static final Logger LOG = LoggerFactory.getLogger(PortalApplicationContext.class);
    private ServletContext servletContext;
    private boolean async;

    public PortalApplicationContext(ServletContext servletContext, DefaultListableBeanFactory beanFactory, boolean async) {
        super(beanFactory);
        this.servletContext = servletContext;
        this.async = async;
    }

    protected void finishBeanFactoryInitialization(ConfigurableListableBeanFactory beanFactory) {
        if (this.async) {
            KernelContainerLifecyclePlugin.addSpringContext(this.servletContext.getServletContextName(), (ApplicationContext)this, (BeanDefinitionRegistry)beanFactory, () -> this.finishSpringContextStartupAsync(beanFactory));
        } else {
            KernelContainerLifecyclePlugin.addSpringContext(this.servletContext.getServletContextName(), (ApplicationContext)this, (BeanDefinitionRegistry)beanFactory, () -> this.finishSpringContextStartup(beanFactory));
        }
    }

    protected void finishRefresh() {
    }

    private void finishSpringContextStartupAsync(ConfigurableListableBeanFactory beanFactory) {
        CompletableFuture.runAsync(() -> {
            Thread currentThread = Thread.currentThread();
            ClassLoader originalClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.servletContext.getClassLoader());
            try {
                do {
                    Thread.sleep(3000L);
                } while (!PortalContainer.getInstance().isStarted());
                Thread.sleep(3000L);
                this.finishSpringContextStartup(beanFactory);
            }
            catch (InterruptedException e) {
                currentThread.interrupt();
            }
            catch (Exception e) {
                LOG.error("Error Initializing Context: {}", (Object)this.servletContext.getServletContextName(), (Object)e);
            }
            finally {
                currentThread.setContextClassLoader(originalClassLoader);
            }
        });
    }

    private void finishSpringContextStartup(ConfigurableListableBeanFactory beanFactory) {
        long start = System.currentTimeMillis();
        LOG.info("Continue Spring context '{}' initialization", (Object)this.servletContext.getServletContextName());
        try {
            PortalApplicationContext.super.finishBeanFactoryInitialization(beanFactory);
            PortalApplicationContext.super.finishRefresh();
            LOG.info("Spring context '{}' initialized in {}ms", (Object)this.servletContext.getServletContextName(), (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error While finishing Beans Initialization in context '%s' with Bean names [%s] (May be related to issue Meeds-io/meeds#2469)", this.servletContext.getServletContextName(), StringUtils.join((Object[])beanFactory.getBeanDefinitionNames(), (String)" , ")), e);
        }
    }
}

