/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.listener.social;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.social.category.model.CategoryObject;
import jakarta.annotation.PostConstruct;
import java.util.Date;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsCategoryLinkListener
extends Listener<CategoryObject, Long> {
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("social.category.object.linked", (ListenerBase)this);
        this.listenerService.addListener("social.category.object.unlinked", (ListenerBase)this);
    }

    public void onEvent(Event<CategoryObject, Long> event) throws Exception {
        StatisticData statisticData = new StatisticData();
        statisticData.setTimestamp(new Date().getTime());
        statisticData.setModule("social");
        statisticData.setSubModule("category");
        switch (event.getEventName()) {
            case "social.category.object.linked": {
                statisticData.setOperation("categoryObjectLinked");
                break;
            }
            case "social.category.object.unlinked": {
                statisticData.setOperation("categoryObjectUnlinked");
                break;
            }
        }
        AnalyticsUtils.addCategoryStatistics((StatisticData)statisticData, (long)((Long)event.getData()));
        AnalyticsUtils.addCategoryLinkStatistics((StatisticData)statisticData, (CategoryObject)((CategoryObject)event.getSource()));
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }
}

