/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.link.storage;

import io.meeds.content.link.constant.LinkAlignType;
import io.meeds.content.link.constant.LinkDisplayType;
import io.meeds.content.link.dao.LinkDAO;
import io.meeds.content.link.dao.LinkSettingDAO;
import io.meeds.content.link.entity.LinkEntity;
import io.meeds.content.link.entity.LinkSettingEntity;
import io.meeds.content.link.model.Link;
import io.meeds.content.link.model.LinkSetting;
import io.meeds.content.link.storage.util.EntityMapper;
import java.time.Instant;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class LinkStorage {
    @Autowired
    private LinkSettingDAO linkSettingDAO;
    @Autowired
    private LinkDAO linkDAO;

    public LinkSetting getLinkSetting(String name) {
        LinkSettingEntity linkSettingEntity = this.linkSettingDAO.findByName(name);
        return EntityMapper.toModel(linkSettingEntity);
    }

    public LinkSetting getLinkSetting(Long linkSettingId) {
        LinkSettingEntity linkSettingEntity = this.linkSettingDAO.findById(linkSettingId).orElse(null);
        return EntityMapper.toModel(linkSettingEntity);
    }

    public boolean hasLinkSetting(String linkSettingName) {
        return this.getLinkSetting(linkSettingName) != null;
    }

    public LinkSetting initLinkSetting(String name, String pageReference, long spaceId) {
        LinkSettingEntity linkSettingEntity = this.linkSettingDAO.findByName(name);
        if (linkSettingEntity == null) {
            linkSettingEntity = new LinkSettingEntity();
            linkSettingEntity.setName(name);
            linkSettingEntity.setPageReference(pageReference);
            linkSettingEntity.setSpaceId(spaceId);
            linkSettingEntity.setShowIcon(true);
            linkSettingEntity.setIconSize(34);
            linkSettingEntity.setType(LinkDisplayType.ROW);
            linkSettingEntity.setVAlign(LinkAlignType.CENTER);
            linkSettingEntity.setHAlign(LinkAlignType.CENTER);
            linkSettingEntity.setLastModified(Instant.now());
            return EntityMapper.toModel((LinkSettingEntity)this.linkSettingDAO.save(linkSettingEntity));
        }
        linkSettingEntity.setPageReference(pageReference);
        return EntityMapper.toModel((LinkSettingEntity)this.linkSettingDAO.save(linkSettingEntity));
    }

    public LinkSetting saveLinkSetting(LinkSetting linkSetting) {
        LinkSettingEntity existingLinkSettingEntity = this.linkSettingDAO.findByName(linkSetting.getName());
        LinkSettingEntity linkSettingEntity = EntityMapper.fromModel(linkSetting, existingLinkSettingEntity);
        return EntityMapper.toModel((LinkSettingEntity)this.linkSettingDAO.save(linkSettingEntity));
    }

    public List<Link> getLinks(String linkSettingName) {
        List<LinkEntity> linkEntities = this.linkDAO.getLinks(linkSettingName);
        return linkEntities.stream().map(EntityMapper::toModel).toList();
    }

    public Link createLink(String linkSettingName, Link link) {
        LinkSettingEntity linkSettingEntity = this.linkSettingDAO.findByName(linkSettingName);
        LinkEntity linkEntity = EntityMapper.fromModel(link, linkSettingEntity);
        linkEntity.setId(null);
        linkEntity = (LinkEntity)this.linkDAO.save(linkEntity);
        this.updateLastModifiedTime(linkSettingEntity);
        return EntityMapper.toModel(linkEntity);
    }

    public Link updateLink(String linkSettingName, Link link) {
        LinkSettingEntity linkSettingEntity = this.linkSettingDAO.findByName(linkSettingName);
        LinkEntity linkEntity = EntityMapper.fromModel(link, linkSettingEntity);
        linkEntity = (LinkEntity)this.linkDAO.save(linkEntity);
        this.updateLastModifiedTime(linkSettingEntity);
        return EntityMapper.toModel(linkEntity);
    }

    public void deleteLink(String linkSettingName, long id) {
        LinkSettingEntity linkSettingEntity = this.linkSettingDAO.findByName(linkSettingName);
        this.linkDAO.deleteById(id);
        this.updateLastModifiedTime(linkSettingEntity);
    }

    private void updateLastModifiedTime(LinkSettingEntity linkSettingEntity) {
        linkSettingEntity.setLastModified(Instant.now());
        this.linkSettingDAO.save(linkSettingEntity);
    }

    public LinkSetting getLinkSettingByLinkId(long linkId) {
        long linkSettingId = this.linkDAO.getLinkSettingByLinkId(linkId);
        return this.getLinkSetting(linkSettingId);
    }
}

