/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._helpers.esql.jdbc;

import co.elastic.clients.elasticsearch._helpers.esql.jdbc.EsType;
import co.elastic.clients.elasticsearch._helpers.esql.jdbc.TypeUtils;
import java.sql.SQLException;
import java.util.Objects;

class JdbcColumnInfo {
    public final String catalog;
    public final String schema;
    public final String table;
    public final String label;
    public final String name;
    public final int displaySize;
    public final EsType type;

    JdbcColumnInfo(String name, String type) throws SQLException {
        this(name, TypeUtils.of(type), "", "", "", "", 0);
    }

    JdbcColumnInfo(String name, EsType type, String table, String catalog, String schema, String label, int displaySize) {
        if (name == null) {
            throw new IllegalArgumentException("[name] must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("[type] must not be null");
        }
        if (table == null) {
            throw new IllegalArgumentException("[table] must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("[catalog] must not be null");
        }
        if (schema == null) {
            throw new IllegalArgumentException("[schema] must not be null");
        }
        if (label == null) {
            throw new IllegalArgumentException("[label] must not be null");
        }
        this.name = name;
        this.type = type;
        this.table = table;
        this.catalog = catalog;
        this.schema = schema;
        this.label = label;
        this.displaySize = displaySize;
    }

    int displaySize() {
        return this.displaySize;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!"".equals(this.table)) {
            b.append(this.table).append('.');
        }
        b.append(this.name).append("<type=[").append(this.type).append(']');
        if (!"".equals(this.catalog)) {
            b.append(" catalog=[").append(this.catalog).append(']');
        }
        if (!"".equals(this.schema)) {
            b.append(" schema=[").append(this.schema).append(']');
        }
        if (!"".equals(this.label)) {
            b.append(" label=[").append(this.label).append(']');
        }
        return b.append('>').toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        JdbcColumnInfo other = (JdbcColumnInfo)obj;
        return this.name.equals(other.name) && this.type.equals(other.type) && this.table.equals(other.table) && this.catalog.equals(other.catalog) && this.schema.equals(other.schema) && this.label.equals(other.label) && this.displaySize == other.displaySize;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.table, this.catalog, this.schema, this.label, this.displaySize);
    }
}

