/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator;

import org.hibernate.Incubating;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.internal.NaturalIdHelper;
import org.hibernate.generator.values.internal.GeneratedValuesHelper;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.GetGeneratedKeysDelegate;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.id.insert.InsertReturningDelegate;
import org.hibernate.id.insert.UniqueKeySelectingDelegate;
import org.hibernate.persister.entity.EntityPersister;

public interface OnExecutionGenerator
extends Generator {
    public boolean referenceColumnsInSql(Dialect var1);

    public boolean writePropertyValue();

    public String[] getReferencedColumnValues(Dialect var1);

    @Incubating
    default public InsertGeneratedIdentifierDelegate getGeneratedIdentifierDelegate(PostInsertIdentityPersister persister) {
        SessionFactoryImplementor factory = persister.getFactory();
        Dialect dialect = factory.getJdbcServices().getDialect();
        if (dialect.supportsInsertReturningGeneratedKeys() && factory.getSessionFactoryOptions().isGetGeneratedKeysEnabled()) {
            return new GetGeneratedKeysDelegate((EntityPersister)persister, false, EventType.INSERT);
        }
        if (dialect.supportsInsertReturning() && GeneratedValuesHelper.noCustomSql(persister, EventType.INSERT)) {
            return new InsertReturningDelegate((EntityPersister)persister, EventType.INSERT);
        }
        return new UniqueKeySelectingDelegate((EntityPersister)persister, this.getUniqueKeyPropertyNames(persister), EventType.INSERT);
    }

    @Incubating
    default public String[] getUniqueKeyPropertyNames(EntityPersister persister) {
        return NaturalIdHelper.getNaturalIdPropertyNames(persister);
    }

    @Override
    default public boolean generatedOnExecution() {
        return true;
    }
}

