/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.WaitForActiveShards;
import co.elastic.clients.elasticsearch.ccr.FollowResponse;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FollowRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String dataStreamName;
    private final String index;
    private final String leaderIndex;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Long maxOutstandingReadRequests;
    @Nullable
    private final Integer maxOutstandingWriteRequests;
    @Nullable
    private final Integer maxReadRequestOperationCount;
    @Nullable
    private final String maxReadRequestSize;
    @Nullable
    private final Time maxRetryDelay;
    @Nullable
    private final Integer maxWriteBufferCount;
    @Nullable
    private final String maxWriteBufferSize;
    @Nullable
    private final Integer maxWriteRequestOperationCount;
    @Nullable
    private final String maxWriteRequestSize;
    @Nullable
    private final Time readPollTimeout;
    private final String remoteCluster;
    @Nullable
    private final IndexSettings settings;
    @Nullable
    private final WaitForActiveShards waitForActiveShards;
    public static final JsonpDeserializer<FollowRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FollowRequest::setupFollowRequestDeserializer);
    public static final Endpoint<FollowRequest, FollowResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<FollowRequest, FollowResponse>("es/ccr.follow", request -> "PUT", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_ccr");
            buf.append("/follow");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("index", request.index);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", request.waitForActiveShards._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, FollowResponse._DESERIALIZER);

    private FollowRequest(Builder builder) {
        this.dataStreamName = builder.dataStreamName;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.leaderIndex = ApiTypeHelper.requireNonNull(builder.leaderIndex, this, "leaderIndex");
        this.masterTimeout = builder.masterTimeout;
        this.maxOutstandingReadRequests = builder.maxOutstandingReadRequests;
        this.maxOutstandingWriteRequests = builder.maxOutstandingWriteRequests;
        this.maxReadRequestOperationCount = builder.maxReadRequestOperationCount;
        this.maxReadRequestSize = builder.maxReadRequestSize;
        this.maxRetryDelay = builder.maxRetryDelay;
        this.maxWriteBufferCount = builder.maxWriteBufferCount;
        this.maxWriteBufferSize = builder.maxWriteBufferSize;
        this.maxWriteRequestOperationCount = builder.maxWriteRequestOperationCount;
        this.maxWriteRequestSize = builder.maxWriteRequestSize;
        this.readPollTimeout = builder.readPollTimeout;
        this.remoteCluster = ApiTypeHelper.requireNonNull(builder.remoteCluster, this, "remoteCluster");
        this.settings = builder.settings;
        this.waitForActiveShards = builder.waitForActiveShards;
    }

    public static FollowRequest of(Function<Builder, ObjectBuilder<FollowRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String dataStreamName() {
        return this.dataStreamName;
    }

    public final String index() {
        return this.index;
    }

    public final String leaderIndex() {
        return this.leaderIndex;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Long maxOutstandingReadRequests() {
        return this.maxOutstandingReadRequests;
    }

    @Nullable
    public final Integer maxOutstandingWriteRequests() {
        return this.maxOutstandingWriteRequests;
    }

    @Nullable
    public final Integer maxReadRequestOperationCount() {
        return this.maxReadRequestOperationCount;
    }

    @Nullable
    public final String maxReadRequestSize() {
        return this.maxReadRequestSize;
    }

    @Nullable
    public final Time maxRetryDelay() {
        return this.maxRetryDelay;
    }

    @Nullable
    public final Integer maxWriteBufferCount() {
        return this.maxWriteBufferCount;
    }

    @Nullable
    public final String maxWriteBufferSize() {
        return this.maxWriteBufferSize;
    }

    @Nullable
    public final Integer maxWriteRequestOperationCount() {
        return this.maxWriteRequestOperationCount;
    }

    @Nullable
    public final String maxWriteRequestSize() {
        return this.maxWriteRequestSize;
    }

    @Nullable
    public final Time readPollTimeout() {
        return this.readPollTimeout;
    }

    public final String remoteCluster() {
        return this.remoteCluster;
    }

    @Nullable
    public final IndexSettings settings() {
        return this.settings;
    }

    @Nullable
    public final WaitForActiveShards waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dataStreamName != null) {
            generator.writeKey("data_stream_name");
            generator.write(this.dataStreamName);
        }
        generator.writeKey("leader_index");
        generator.write(this.leaderIndex);
        if (this.maxOutstandingReadRequests != null) {
            generator.writeKey("max_outstanding_read_requests");
            generator.write(this.maxOutstandingReadRequests.longValue());
        }
        if (this.maxOutstandingWriteRequests != null) {
            generator.writeKey("max_outstanding_write_requests");
            generator.write(this.maxOutstandingWriteRequests.intValue());
        }
        if (this.maxReadRequestOperationCount != null) {
            generator.writeKey("max_read_request_operation_count");
            generator.write(this.maxReadRequestOperationCount.intValue());
        }
        if (this.maxReadRequestSize != null) {
            generator.writeKey("max_read_request_size");
            generator.write(this.maxReadRequestSize);
        }
        if (this.maxRetryDelay != null) {
            generator.writeKey("max_retry_delay");
            this.maxRetryDelay.serialize(generator, mapper);
        }
        if (this.maxWriteBufferCount != null) {
            generator.writeKey("max_write_buffer_count");
            generator.write(this.maxWriteBufferCount.intValue());
        }
        if (this.maxWriteBufferSize != null) {
            generator.writeKey("max_write_buffer_size");
            generator.write(this.maxWriteBufferSize);
        }
        if (this.maxWriteRequestOperationCount != null) {
            generator.writeKey("max_write_request_operation_count");
            generator.write(this.maxWriteRequestOperationCount.intValue());
        }
        if (this.maxWriteRequestSize != null) {
            generator.writeKey("max_write_request_size");
            generator.write(this.maxWriteRequestSize);
        }
        if (this.readPollTimeout != null) {
            generator.writeKey("read_poll_timeout");
            this.readPollTimeout.serialize(generator, mapper);
        }
        generator.writeKey("remote_cluster");
        generator.write(this.remoteCluster);
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
    }

    protected static void setupFollowRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataStreamName, JsonpDeserializer.stringDeserializer(), "data_stream_name");
        op.add(Builder::leaderIndex, JsonpDeserializer.stringDeserializer(), "leader_index");
        op.add(Builder::maxOutstandingReadRequests, JsonpDeserializer.longDeserializer(), "max_outstanding_read_requests");
        op.add(Builder::maxOutstandingWriteRequests, JsonpDeserializer.integerDeserializer(), "max_outstanding_write_requests");
        op.add(Builder::maxReadRequestOperationCount, JsonpDeserializer.integerDeserializer(), "max_read_request_operation_count");
        op.add(Builder::maxReadRequestSize, JsonpDeserializer.stringDeserializer(), "max_read_request_size");
        op.add(Builder::maxRetryDelay, Time._DESERIALIZER, "max_retry_delay");
        op.add(Builder::maxWriteBufferCount, JsonpDeserializer.integerDeserializer(), "max_write_buffer_count");
        op.add(Builder::maxWriteBufferSize, JsonpDeserializer.stringDeserializer(), "max_write_buffer_size");
        op.add(Builder::maxWriteRequestOperationCount, JsonpDeserializer.integerDeserializer(), "max_write_request_operation_count");
        op.add(Builder::maxWriteRequestSize, JsonpDeserializer.stringDeserializer(), "max_write_request_size");
        op.add(Builder::readPollTimeout, Time._DESERIALIZER, "read_poll_timeout");
        op.add(Builder::remoteCluster, JsonpDeserializer.stringDeserializer(), "remote_cluster");
        op.add(Builder::settings, IndexSettings._DESERIALIZER, "settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FollowRequest> {
        @Nullable
        private String dataStreamName;
        private String index;
        private String leaderIndex;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Long maxOutstandingReadRequests;
        @Nullable
        private Integer maxOutstandingWriteRequests;
        @Nullable
        private Integer maxReadRequestOperationCount;
        @Nullable
        private String maxReadRequestSize;
        @Nullable
        private Time maxRetryDelay;
        @Nullable
        private Integer maxWriteBufferCount;
        @Nullable
        private String maxWriteBufferSize;
        @Nullable
        private Integer maxWriteRequestOperationCount;
        @Nullable
        private String maxWriteRequestSize;
        @Nullable
        private Time readPollTimeout;
        private String remoteCluster;
        @Nullable
        private IndexSettings settings;
        @Nullable
        private WaitForActiveShards waitForActiveShards;

        public final Builder dataStreamName(@Nullable String value) {
            this.dataStreamName = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder leaderIndex(String value) {
            this.leaderIndex = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxOutstandingReadRequests(@Nullable Long value) {
            this.maxOutstandingReadRequests = value;
            return this;
        }

        public final Builder maxOutstandingWriteRequests(@Nullable Integer value) {
            this.maxOutstandingWriteRequests = value;
            return this;
        }

        public final Builder maxReadRequestOperationCount(@Nullable Integer value) {
            this.maxReadRequestOperationCount = value;
            return this;
        }

        public final Builder maxReadRequestSize(@Nullable String value) {
            this.maxReadRequestSize = value;
            return this;
        }

        public final Builder maxRetryDelay(@Nullable Time value) {
            this.maxRetryDelay = value;
            return this;
        }

        public final Builder maxRetryDelay(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.maxRetryDelay(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxWriteBufferCount(@Nullable Integer value) {
            this.maxWriteBufferCount = value;
            return this;
        }

        public final Builder maxWriteBufferSize(@Nullable String value) {
            this.maxWriteBufferSize = value;
            return this;
        }

        public final Builder maxWriteRequestOperationCount(@Nullable Integer value) {
            this.maxWriteRequestOperationCount = value;
            return this;
        }

        public final Builder maxWriteRequestSize(@Nullable String value) {
            this.maxWriteRequestSize = value;
            return this;
        }

        public final Builder readPollTimeout(@Nullable Time value) {
            this.readPollTimeout = value;
            return this;
        }

        public final Builder readPollTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.readPollTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder remoteCluster(String value) {
            this.remoteCluster = value;
            return this;
        }

        public final Builder settings(@Nullable IndexSettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.settings(fn.apply(new IndexSettings.Builder()).build());
        }

        public final Builder waitForActiveShards(@Nullable WaitForActiveShards value) {
            this.waitForActiveShards = value;
            return this;
        }

        public final Builder waitForActiveShards(Function<WaitForActiveShards.Builder, ObjectBuilder<WaitForActiveShards>> fn) {
            return this.waitForActiveShards(fn.apply(new WaitForActiveShards.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FollowRequest build() {
            this._checkSingleUse();
            return new FollowRequest(this);
        }
    }
}

