/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.model.key;

import java.util.Arrays;
import java.util.Objects;
import org.exoplatform.social.core.activity.ActivityFilter;
import org.exoplatform.social.core.storage.cache.model.key.ActivityKey;
import org.exoplatform.social.core.storage.cache.model.key.ActivityType;
import org.exoplatform.social.core.storage.cache.model.key.CacheKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityKey;

public class ActivityListKey
implements CacheKey {
    private static final long serialVersionUID = -2153747306033203041L;
    private IdentityKey key;
    private IdentityKey viewerKey;
    private ActivityKey activityKey;
    private String baseId;
    private ActivityType type;
    private transient ActivityFilter activityFilter;
    private Long time;
    private String[] activityTypes;

    public ActivityListKey(IdentityKey key, ActivityType type) {
        this.key = key;
        this.type = type;
    }

    public ActivityListKey(IdentityKey key, ActivityType type, String ... activityTypes) {
        this.key = key;
        this.type = type;
        this.activityTypes = activityTypes;
    }

    public ActivityListKey(IdentityKey key, IdentityKey viewerKey, ActivityType type) {
        this.key = key;
        this.type = type;
        this.viewerKey = viewerKey;
    }

    public ActivityListKey(IdentityKey key, String baseId, ActivityType type) {
        this.key = key;
        this.baseId = baseId;
        this.type = type;
    }

    public ActivityListKey(IdentityKey key, Long time, ActivityType type) {
        this.key = key;
        this.time = time;
        this.type = type;
    }

    public ActivityListKey(ActivityKey activityKey, Long time, ActivityType type) {
        this.activityKey = activityKey;
        this.time = time;
        this.type = type;
    }

    public ActivityListKey(String baseId, ActivityType type) {
        this.baseId = baseId;
        this.type = type;
    }

    public ActivityListKey(IdentityKey key, ActivityFilter activityFilter) {
        this.key = key;
        this.activityFilter = activityFilter;
    }

    public IdentityKey getKey() {
        return this.key;
    }

    public ActivityKey getActivityKey() {
        return this.activityKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActivityListKey)) {
            return false;
        }
        ActivityListKey that = (ActivityListKey)o;
        return (this.baseId != null ? !this.baseId.equals(that.baseId) : that.baseId != null) && (this.key != null ? !this.key.equals(that.key) : that.key != null) && (this.activityKey != null ? !this.activityKey.equals(that.activityKey) : that.activityKey != null) && (this.activityTypes != null ? !Arrays.equals(this.activityTypes, that.activityTypes) : that.activityTypes != null) && (this.activityFilter != null ? !this.activityFilter.equals((Object)that.activityFilter) : that.activityFilter != null) && this.type != that.type && this.time != that.time;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activityKey, this.activityTypes, this.activityFilter, this.viewerKey, this.baseId, this.baseId, this.type, this.time});
    }
}

