/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.storage;

import io.meeds.kudos.dao.KudosDAO;
import io.meeds.kudos.entity.KudosEntity;
import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.model.KudosEntityType;
import io.meeds.kudos.model.KudosPeriod;
import io.meeds.kudos.service.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Limit;
import org.springframework.stereotype.Component;

@Component
public class KudosStorage {
    private static final Log LOG = ExoLogger.getLogger(KudosStorage.class);
    @Autowired
    private KudosDAO kudosDAO;
    @Autowired
    private IdentityManager identityManager;

    public Kudos getKudoById(long id) {
        KudosEntity kudosEntity = this.kudosDAO.findById(id).orElse(null);
        if (kudosEntity == null) {
            LOG.warn("Can't find Kudos with id {}", new Object[]{id});
            return null;
        }
        return Utils.fromEntity(kudosEntity);
    }

    public Kudos createKudos(Kudos kudos) {
        KudosEntity kudosEntity = Utils.toEntity(kudos);
        kudosEntity.setId(null);
        kudosEntity = (KudosEntity)this.kudosDAO.save(kudosEntity);
        return Utils.fromEntity(kudosEntity);
    }

    public void deleteKudosById(long kudosId) {
        this.kudosDAO.deleteById(kudosId);
    }

    public void saveKudosActivityId(long kudosId, long activityId) {
        KudosEntity kudosEntity = this.kudosDAO.findById(kudosId).orElse(null);
        if (kudosEntity == null) {
            throw new IllegalStateException("Can't find Kudos with id " + kudosId);
        }
        kudosEntity.setActivityId(activityId);
        this.kudosDAO.save(kudosEntity);
    }

    public List<Kudos> getKudosByPeriod(KudosPeriod kudosPeriod, int limit) {
        ArrayList<Kudos> kudosList = new ArrayList<Kudos>();
        List<KudosEntity> kudosEntities = this.kudosDAO.findByCreatedDateBetweenOrderByCreatedDateDesc(kudosPeriod.getStartDateInSeconds(), kudosPeriod.getEndDateInSeconds(), Limit.of((int)limit));
        if (kudosEntities != null) {
            for (KudosEntity kudosEntity : kudosEntities) {
                if (kudosEntity == null) continue;
                kudosList.add(Utils.fromEntity(kudosEntity));
            }
        }
        return kudosList;
    }

    public List<Kudos> getKudosByEntity(String entityType, String entityId, int limit) {
        ArrayList<Kudos> kudosList = new ArrayList<Kudos>();
        List<KudosEntity> kudosEntities = this.kudosDAO.findByEntityTypeAndEntityIdOrderByCreatedDateDesc(KudosEntityType.valueOf(entityType).ordinal(), Long.parseLong(entityId), Limit.of((int)limit));
        if (kudosEntities != null) {
            for (KudosEntity kudosEntity : kudosEntities) {
                if (kudosEntity == null) continue;
                kudosList.add(Utils.fromEntity(kudosEntity));
            }
        }
        return kudosList;
    }

    public long countKudosByEntity(String entityType, String entityId) {
        return this.kudosDAO.countByEntityTypeAndEntityId(KudosEntityType.valueOf(entityType).ordinal(), Long.parseLong(entityId));
    }

    public long countKudosByEntityAndSender(String entityType, String entityId, String senderIdentityId) {
        return this.kudosDAO.countByEntityTypeAndEntityIdAndSenderId(KudosEntityType.valueOf(entityType).ordinal(), Long.parseLong(entityId), Long.parseLong(senderIdentityId));
    }

    public long countKudosByPeriodAndReceiver(KudosPeriod kudosPeriod, String receiverType, String receiverId) {
        boolean isReceiverUser = "user".equals(receiverType) || "organization".equals(receiverType);
        Identity identity = this.getIdentityManager().getOrCreateIdentity(isReceiverUser ? "organization" : "space", receiverId);
        return this.kudosDAO.countByCreatedDateBetweenAndReceiverIdAndIsReceiverUser(kudosPeriod.getStartDateInSeconds(), kudosPeriod.getEndDateInSeconds(), Long.parseLong(identity.getId()), isReceiverUser);
    }

    public Map<Long, Long> countKudosByPeriodAndReceivers(KudosPeriod kudosPeriod, List<Long> receiversId) {
        return this.kudosDAO.countByCreatedDateBetweenAndReceiverIdIn(kudosPeriod.getStartDateInSeconds(), kudosPeriod.getEndDateInSeconds(), receiversId).stream().collect(Collectors.toMap(r -> r.getReceiverId(), r -> r.getCount()));
    }

    public List<Kudos> getKudosByPeriodAndReceiver(KudosPeriod kudosPeriod, String receiverType, String receiverId, int limit) {
        boolean isReceiverUser = "user".equals(receiverType) || "organization".equals(receiverType);
        long identityId = this.getIdentityId(receiverId, isReceiverUser);
        if (identityId <= 0L) {
            return Collections.emptyList();
        }
        List<KudosEntity> kudosEntities = this.kudosDAO.findByCreatedDateBetweenAndReceiverIdAndIsReceiverUserOrderByIdDesc(kudosPeriod.getStartDateInSeconds(), kudosPeriod.getEndDateInSeconds(), identityId, isReceiverUser, Limit.of((int)limit));
        if (kudosEntities != null) {
            ArrayList<Kudos> kudosList = new ArrayList<Kudos>();
            for (KudosEntity kudosEntity : kudosEntities) {
                if (kudosEntity == null) continue;
                kudosList.add(Utils.fromEntity(kudosEntity));
            }
            return kudosList;
        }
        return Collections.emptyList();
    }

    public List<Kudos> getKudosByPeriodAndSender(KudosPeriod kudosPeriod, long senderIdentityId, int limit) {
        ArrayList<Kudos> kudosList = new ArrayList<Kudos>();
        List<KudosEntity> kudosEntities = this.kudosDAO.findByCreatedDateBetweenAndSenderIdOrderByCreatedDateDesc(kudosPeriod.getStartDateInSeconds(), kudosPeriod.getEndDateInSeconds(), senderIdentityId, Limit.of((int)limit));
        if (kudosEntities != null) {
            for (KudosEntity kudosEntity : kudosEntities) {
                if (kudosEntity == null) continue;
                kudosList.add(Utils.fromEntity(kudosEntity));
            }
        }
        return kudosList;
    }

    public long countKudosByPeriodAndSender(KudosPeriod kudosPeriod, long senderIdentityId) {
        return this.kudosDAO.countByCreatedDateBetweenAndSenderId(kudosPeriod.getStartDateInSeconds(), kudosPeriod.getEndDateInSeconds(), senderIdentityId);
    }

    private long getIdentityId(String remoteId, boolean isReceiverUser) {
        long identityId = 0L;
        if (isReceiverUser) {
            Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", remoteId);
            if (identity == null) {
                return 0L;
            }
            identityId = Long.parseLong(identity.getId());
        } else {
            Space space = Utils.getSpace(remoteId);
            if (space == null) {
                return 0L;
            }
            identityId = Long.parseLong(space.getId());
        }
        return identityId;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        }
        return this.identityManager;
    }

    public Kudos getKudosByActivityId(Long activityId) {
        KudosEntity kudosEntity = this.kudosDAO.findByActivityId(activityId);
        return Utils.fromEntity(kudosEntity);
    }

    public List<Kudos> getKudosListOfActivity(Long activityId) {
        List<KudosEntity> kudosEntities = this.kudosDAO.findKudosListOfActivity(activityId, Arrays.asList(KudosEntityType.ACTIVITY.ordinal(), KudosEntityType.COMMENT.ordinal()));
        return CollectionUtils.isEmpty(kudosEntities) ? Collections.emptyList() : kudosEntities.stream().map(Utils::fromEntity).toList();
    }

    public long countKudosOfActivity(Long activityId) {
        return this.kudosDAO.countKudosListOfActivity(activityId, Arrays.asList(KudosEntityType.ACTIVITY.ordinal(), KudosEntityType.COMMENT.ordinal()));
    }

    public Kudos updateKudos(Kudos kudos) {
        KudosEntity kudosEntity = Utils.toEntity(kudos);
        kudosEntity = (KudosEntity)this.kudosDAO.save(kudosEntity);
        return Utils.fromEntity(kudosEntity);
    }
}

